/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.config;

import feign.auth.BasicAuthRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix="app.feign")
@ConditionalOnProperty(name={"app.feign.enable"}, havingValue="true", matchIfMissing=false)
@EnableFeignClients(basePackages={"com.cntaiping.fsc.feignapi"})
public class FeignConfig {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ConfigurableEnvironment environment;

    public FeignConfig() {
        this.LOG.debug("Init FeignConfig.");
    }

    @Bean
    @ConditionalOnProperty(value={"spring.security.user.password"}, matchIfMissing=false)
    public BasicAuthRequestInterceptor basicAuthRequestInterceptor() {
        this.LOG.info("Init FeignConfig create BasicAuthRequestInterceptor for feign client");
        String userName = this.environment.getProperty("spring.security.user.name");
        String password = this.environment.getProperty("spring.security.user.password");
        return new BasicAuthRequestInterceptor(userName, password);
    }
}

