/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.config;

import com.cntaiping.fsc.common.config.CommonProperties;
import com.cntaiping.fsc.common.error.GlobalWebExceptionHandler;
import com.cntaiping.fsc.security.config.AppIdGenerator;
import com.cntaiping.fsc.security.interceptor.TpAppTokenExchangeFilterFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.error.ErrorWebFluxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@EnableConfigurationProperties(value={CommonProperties.class})
@AutoConfigureAfter(value={RedisReactiveAutoConfiguration.class})
@AutoConfigureBefore(value={ErrorWebFluxAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class ReactiveCommonConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveCommonConfig.class);
    @Autowired
    private CommonProperties commonProperties;

    public ReactiveCommonConfig() {
        LOGGER.debug("Init Tpcloud ReactiveCommonConfig.");
    }

    @Bean
    public GlobalWebExceptionHandler globalWebExceptionHandler() {
        return new GlobalWebExceptionHandler();
    }

    @Primary
    @Bean(name={"loadBalancedWebClient"})
    @ConditionalOnMissingBean(name={"loadBalancedWebClient"})
    public WebClient loadBalancedWebClient(@Qualifier(value="loadBalancedWebClientBuilder") WebClient.Builder loadBalancedWebClientBuilder) {
        LOGGER.info("Init loadBalancedWebClient");
        return loadBalancedWebClientBuilder.build();
    }

    @Bean(name={"normalWebClient"})
    @ConditionalOnMissingBean(name={"normalWebClient"})
    public WebClient normalWebClient(@Qualifier(value="webClientBuilder") WebClient.Builder WebClientBuilder) {
        LOGGER.info("Init normalWebClient");
        return WebClientBuilder.build();
    }

    @Bean(name={"loadBalancedWebClientBuilder"})
    @Primary
    @LoadBalanced
    public WebClient.Builder loadBalancedWebClientBuilder(ObjectProvider<WebClientCustomizer> customizerProvider, TpAppTokenExchangeFilterFunction filterFunction) {
        LOGGER.info("Init loadBalancedWebClientBuilder");
        WebClient.Builder builder = WebClient.builder();
        customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
        builder.filter((ExchangeFilterFunction)filterFunction);
        return builder;
    }

    @Bean(name={"webClientBuilder"})
    public WebClient.Builder webClientBuilder(ObjectProvider<WebClientCustomizer> customizerProvider) {
        LOGGER.info("Init webClientBuilder");
        WebClient.Builder builder = WebClient.builder();
        customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    @Bean
    public TpAppTokenExchangeFilterFunction tpAppTokenExchangeFilterFunction(Environment env) {
        LOGGER.info("Init TpAppTokenExchangeFilterFunction");
        String appId = new AppIdGenerator(env).toString();
        return new TpAppTokenExchangeFilterFunction(appId);
    }
}

