/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import com.cntaiping.fsc.common.util.ExcelData;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExportExcelUtils {
    public static void exportExcel(HttpServletResponse response, String fileName, ExcelData data) throws Exception {
        response.setHeader("content-Type", "application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
        ExportExcelUtils.exportExcel(data, (OutputStream)response.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportExcel(ExcelData data, OutputStream out) throws Exception {
        try (HSSFWorkbook wb = new HSSFWorkbook();){
            String sheetName = data.getName();
            if (null == sheetName) {
                sheetName = "Sheet1";
            }
            HSSFSheet sheet = wb.createSheet(sheetName);
            ExportExcelUtils.writeExcel(wb, sheet, data);
            wb.write(out);
        }
    }

    private static void writeExcel(HSSFWorkbook wb, HSSFSheet sheet, ExcelData data) {
        int rowIndex = 0;
        rowIndex = ExportExcelUtils.writeTitlesToExcel(wb, sheet, data.getTitles(), rowIndex, 0);
        ExportExcelUtils.writeRowsToExcel(wb, sheet, data, rowIndex);
    }

    private static int writeTitlesToExcel(HSSFWorkbook wb, HSSFSheet sheet, HashMap<String, Object> titles, int rowIndex, int titleCols) {
        int colIndex = 0;
        HSSFCellStyle titleStyle = wb.createCellStyle();
        if (titleCols != 0) {
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, titleCols));
        }
        HSSFRow titleRow = sheet.createRow(rowIndex);
        colIndex = 0;
        for (Map.Entry<String, Object> entry : titles.entrySet()) {
            HSSFCell cell = titleRow.createCell(colIndex);
            cell.setCellValue(entry.getKey());
            cell.setCellStyle(titleStyle);
            ++colIndex;
        }
        return ++rowIndex;
    }

    private static int writeRowsToExcel(HSSFWorkbook wb, HSSFSheet sheet, ExcelData data, int rowIndex) {
        int colIndex = 0;
        HSSFCellStyle dataStyle = wb.createCellStyle();
        LinkedHashMap<String, Object> titles = data.getTitles();
        List<HashMap<String, Object>> rows = data.getRows();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        for (HashMap<String, Object> rowData : rows) {
            HSSFRow dataRow = sheet.createRow(rowIndex);
            colIndex = 0;
            for (Map.Entry entry : ((HashMap)titles).entrySet()) {
                HSSFCell cell = dataRow.createCell(colIndex);
                if (rowData.containsKey(entry.getValue())) {
                    if (rowData.get(entry.getValue()) != null) {
                        String type = rowData.get(entry.getValue()).getClass().getTypeName();
                        if (type.endsWith("Date")) {
                            String format = simpleDateFormat.format(rowData.get(entry.getValue()));
                            cell.setCellValue(format);
                        } else {
                            cell.setCellValue(rowData.get(entry.getValue()).toString());
                        }
                    }
                } else {
                    cell.setCellValue("");
                }
                cell.setCellStyle(dataStyle);
                ++colIndex;
            }
            ++rowIndex;
        }
        return rowIndex;
    }

    public static String getExcelBytes(ExcelData data, String mainTitle, int titleCols) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        String sheetName = data.getName();
        if (null == sheetName) {
            sheetName = "Sheet1";
        }
        HSSFSheet sheet = wb.createSheet(sheetName);
        int rowIndex = 0;
        if (StringUtils.isNotBlank((CharSequence)mainTitle)) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(mainTitle, "mainTitle");
            rowIndex = ExportExcelUtils.writeTitlesToExcel(wb, sheet, map, 0, titleCols);
        }
        rowIndex = ExportExcelUtils.writeTitlesToExcel(wb, sheet, data.getTitles(), rowIndex, 0);
        List<HashMap<String, Object>> rows = data.getRows();
        int count = rows.size();
        int pageSize = 100;
        List<Object> list = new ArrayList();
        ExcelData data1 = new ExcelData();
        int len = count / pageSize + 1;
        for (int i = 1; i <= len; ++i) {
            list = null;
            if (i == len) {
                list = rows.subList((i - 1) * pageSize, count);
                list.size();
            } else {
                list = rows.subList((i - 1) * pageSize, i * pageSize);
                list.size();
            }
            data1.setRows(null);
            data1.setTitles(null);
            data1.setName(null);
            data1.setRows(list);
            data1.setTitles(data.getTitles());
            data1.setName(data.getName());
            if (i == 1) {
                ExportExcelUtils.writeRowsToExcel(wb, sheet, data1, rowIndex);
                continue;
            }
            ExportExcelUtils.append2Execl(wb, data1);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        wb.write((OutputStream)baos);
        byte[] xls = baos.toByteArray();
        wb.close();
        baos.close();
        return Base64.getEncoder().encodeToString(xls);
    }

    public static String append2Execl(HSSFWorkbook workbook, ExcelData data) throws Exception {
        if (data == null) {
            return null;
        }
        List<HashMap<String, Object>> rows = data.getRows();
        if (CollectionUtils.isEmpty(rows)) {
            return null;
        }
        LinkedHashMap<String, Object> titles = data.getTitles();
        if (MapUtils.isEmpty(titles)) {
            return null;
        }
        HSSFSheet sheet = workbook.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum() + 1;
        ExportExcelUtils.writeRowsToExcel(workbook, sheet, data, lastRowNum);
        return null;
    }
}

