/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cntaiping.fsc.common.util.StringUtils;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class HttpClientUtil {
    private static Logger LOG = LoggerFactory.getLogger(HttpClientUtil.class);
    private final RestTemplate loadBalancedRestTemplate;
    private final RestTemplate normalRestTemplate;

    public HttpClientUtil(RestTemplate loadBalancedRestTemplate, RestTemplate normalRestTemplate) {
        Assert.notNull((Object)loadBalancedRestTemplate, (String)"LoadBalancedRestTemplate can not be null when init HttpClientUtil!");
        Assert.notNull((Object)normalRestTemplate, (String)"NormalRestTemplate can not be null when init HttpClientUtil!");
        this.loadBalancedRestTemplate = loadBalancedRestTemplate;
        this.normalRestTemplate = normalRestTemplate;
        LOG.debug("Init HttpClientUtil.");
    }

    public RestTemplate selectRestTemplate(boolean isLoadBalanced) {
        if (isLoadBalanced) {
            return this.loadBalancedRestTemplate;
        }
        return this.normalRestTemplate;
    }

    public Object requestPost(String url, String params) throws Exception {
        return this.requestPost(url, params, true);
    }

    public Object requestPost(String url, String params, boolean isLoadBalanced) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity result = this.selectRestTemplate(isLoadBalanced).exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        HttpStatusCode statusCode = result.getStatusCode();
        LOG.debug("Http Response StatusCode: " + statusCode);
        if (!statusCode.equals(HttpStatus.OK)) {
            String errorReason = this.getErrorReason(statusCode);
            String msg = MessageFormat.format("Http Request Error, statusCode: {0}, reason: {1}", statusCode, errorReason);
            throw new RestClientException(msg);
        }
        return JSONObject.parseObject((String)((String)result.getBody())).get((Object)"resData");
    }

    private String getErrorReason(HttpStatusCode statusCode) {
        HttpStatus httpStatus = HttpStatus.resolve((int)statusCode.value());
        return httpStatus == null ? "unknown" : httpStatus.getReasonPhrase();
    }

    public String requestPostForFilter(String url, String params) throws Exception {
        return this.requestPostForFilter(url, params, true);
    }

    public String requestPostForFilter(String url, String params, boolean isLoadBalanced) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity result = this.selectRestTemplate(isLoadBalanced).exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        HttpStatusCode statusCode = result.getStatusCode();
        LOG.debug("Http Response StatusCode: " + statusCode);
        if (!statusCode.equals(HttpStatus.OK)) {
            String errorReason = this.getErrorReason(statusCode);
            throw new RestClientException(String.format("Http Request Error, statusCode: %s, reason: %s", statusCode, errorReason));
        }
        return (String)result.getBody();
    }

    public Object requestPostForObjectFilter(String url, String params) throws Exception {
        return this.requestPostForObjectFilter(url, params, true);
    }

    public Object requestPostForObjectFilter(String url, String params, boolean isLoadBalanced) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity result = this.selectRestTemplate(isLoadBalanced).exchange(url, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        HttpStatusCode statusCode = result.getStatusCode();
        LOG.debug("Http Response StatusCode: " + statusCode);
        if (!statusCode.equals(HttpStatus.OK)) {
            String errorReason = this.getErrorReason(statusCode);
            throw new RestClientException(String.format("Http Request Error, statusCode: %s, reason: %s", statusCode, errorReason));
        }
        return result.getBody();
    }

    public Object requestGet(String url, String params) throws Exception {
        return this.requestGet(url, params, true);
    }

    public Object requestGet(String url, String params, boolean isLoadBalanced) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        Object realUrl = StringUtils.isEmpty(params) ? url : url + "/" + params;
        ResponseEntity result = this.selectRestTemplate(isLoadBalanced).getForEntity((String)realUrl, String.class, new Object[0]);
        HttpStatusCode statusCode = result.getStatusCode();
        LOG.debug("Http Response StatusCode: " + statusCode);
        if (!statusCode.equals(HttpStatus.OK)) {
            String errorReason = this.getErrorReason(statusCode);
            throw new RestClientException(String.format("Http Request Error, statusCode: %s, reason: %s", statusCode, errorReason));
        }
        return JSONObject.parseObject((String)((String)result.getBody())).get((Object)"resData");
    }

    public ResponseEntity<JSONObject> getDataFromInterface(String url, JSONObject jsonParam) {
        return this.getDataFromInterface(url, jsonParam, true);
    }

    public ResponseEntity<JSONObject> getDataFromInterface(String url, JSONObject jsonParam, boolean isLoadBalanced) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        ResponseEntity res = this.selectRestTemplate(isLoadBalanced).postForEntity(url, (Object)new HttpEntity((Object)JSON.toJSONString((Object)jsonParam), (MultiValueMap)headers), JSONObject.class, new Object[0]);
        return res;
    }
}

