/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import com.cntaiping.fsc.common.util.DataUtils;
import com.cntaiping.fsc.common.util.DateTime;
import com.cntaiping.fsc.common.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ObjectUtils {
    private static final Log logger = LogFactory.getLog(ObjectUtils.class);
    public static final String SPLIT_DELIMITER = "^";
    public static Class<Object>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static Map<String, Method[]> methodMap = new ConcurrentHashMap<String, Method[]>();

    private ObjectUtils() {
    }

    public static String getClassNameWithoutPackage(Class cl) {
        String className = cl.getName();
        int pos = className.lastIndexOf(46) + 1;
        if (pos == -1) {
            pos = 0;
        }
        return className.substring(pos);
    }

    public static void printConstructors(Class cl) {
        logger.info((Object)"    //Constructors");
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            logger.info((Object)("    " + Modifier.toString(constructors[i].getModifiers())));
            logger.info((Object)(" " + constructors[i].getName() + "("));
            Class<?>[] paramTypes = constructors[i].getParameterTypes();
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    logger.info((Object)", ");
                }
                logger.info((Object)paramTypes[j].getName());
            }
            logger.info((Object)")");
            Class<?>[] exceptions = constructors[i].getExceptionTypes();
            for (int j = 0; j < exceptions.length; ++j) {
                if (j == 0) {
                    logger.info((Object)"throws ");
                } else if (j > 0) {
                    logger.info((Object)", ");
                }
                logger.info((Object)exceptions[j].getName());
            }
            logger.info((Object)";");
        }
    }

    public static void printMethods(Class cl) {
        logger.info((Object)"    //Methods");
        Method[] methods = ObjectUtils.getMethods(cl);
        for (int i = 0; i < methods.length; ++i) {
            logger.info((Object)("    " + Modifier.toString(methods[i].getModifiers())));
            logger.info((Object)(" " + methods[i].getReturnType() + " " + methods[i].getName() + "("));
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    logger.info((Object)", ");
                }
                logger.info((Object)paramTypes[j].getName());
            }
            logger.info((Object)")");
            Class<?>[] exceptions = methods[i].getExceptionTypes();
            for (int j = 0; j < exceptions.length; ++j) {
                if (j == 0) {
                    logger.info((Object)"throws ");
                } else if (j > 0) {
                    logger.info((Object)", ");
                }
                logger.info((Object)exceptions[j].getName());
            }
            logger.info((Object)";");
        }
    }

    public static void printFields(Class cl) throws Exception {
        logger.info((Object)"    //Fields");
        Field[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            logger.info((Object)("    " + Modifier.toString(fields[i].getModifiers())));
            logger.info((Object)(" " + fields[i].getType() + " " + fields[i].getName()));
            logger.info((Object)";");
        }
    }

    public static Object invoke(String className, String methodName, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> cl = Class.forName(className);
        Method method = ObjectUtils.getMethod(cl, methodName, argsClass);
        return method.invoke(cl.getConstructor(new Class[0]).newInstance(new Object[0]), args);
    }

    public static Object invoke(Object oldObject, String methodName, Class[] argsClass, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = ObjectUtils.getMethod(oldObject.getClass(), methodName, argsClass);
        return method.invoke(oldObject, args);
    }

    public static String[] getFieldsName(Class cl) throws Exception {
        Field[] fields = cl.getDeclaredFields();
        int size = fields.length;
        String[] fieldNames = new String[size];
        for (int i = 0; i < size; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    public static List<String> getAllFieldName(Class cl) {
        LinkedList<String> list = new LinkedList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        ObjectUtils.initAllFieldName(cl, list, map);
        return list;
    }

    private static void initAllFieldName(Class cl, List<String> list, Map<String, String> map) {
        for (Field field : cl.getDeclaredFields()) {
            String fieldName = field.getName();
            if (fieldName.equals("serialVersionUID") || map.containsKey(fieldName)) continue;
            map.put(fieldName, null);
            list.add(fieldName);
        }
        Class superClass = cl;
        while ((superClass = superClass.getSuperclass()) != Object.class) {
            list.addAll(ObjectUtils.getAllFieldName(superClass));
        }
    }

    private static void initClassMethod(Class cl) {
        String key = cl.getName();
        if (methodMap.containsKey(key)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        LinkedList<Method> list = new LinkedList<Method>();
        ObjectUtils.initClassMethodInner(cl, list, map);
        Method[] methods = new Method[list.size()];
        list.toArray(methods);
        methodMap.put(key, methods);
    }

    private static void initClassMethodInner(Class cl, List<Method> list, Map<String, String> map) {
        for (Method method : cl.getDeclaredMethods()) {
            String key = method.toString();
            if (map.containsKey(key)) continue;
            map.put(key, null);
            list.add(method);
        }
        Class superClass = cl;
        while ((superClass = superClass.getSuperclass()) != Object.class) {
            ObjectUtils.initClassMethodInner(superClass, list, map);
        }
    }

    public static Method[] getMethods(Class cl) {
        ObjectUtils.initClassMethod(cl);
        return methodMap.get(cl.getName());
    }

    public static List<Method> getSetter(Class cl) {
        Method[] list = ObjectUtils.getMethods(cl);
        ArrayList<Method> resultList = new ArrayList<Method>();
        for (Method method : list) {
            String methodName = method.getName();
            if (methodName.length() < 3 || method.getParameterTypes().length != 1 || methodName.charAt(0) != 's' || methodName.charAt(1) != 'e' || methodName.charAt(2) != 't') continue;
            resultList.add(method);
        }
        return resultList;
    }

    public static List<Method> getGetter(Class cl) {
        Method[] list = ObjectUtils.getMethods(cl);
        ArrayList<Method> resultList = new ArrayList<Method>();
        for (Method method : list) {
            String methodName = method.getName();
            if (methodName.length() < 3 || method.getParameterTypes().length != 0) continue;
            if (methodName.charAt(0) == 'g' && methodName.charAt(1) == 'e' && methodName.charAt(2) == 't') {
                resultList.add(method);
                continue;
            }
            if (methodName.charAt(0) != 'i' || methodName.charAt(1) != 's') continue;
            resultList.add(method);
        }
        return resultList;
    }

    public static Method getMethod(Class cl, String methodName, Class[] argsClass) throws SecurityException, NoSuchMethodException {
        Method[] list = ObjectUtils.getMethods(cl);
        int argsLength = 0;
        if (argsClass != null) {
            argsLength = argsClass.length;
        }
        for (Method method : list) {
            Class<?>[] types;
            int typeLength;
            if (!method.getName().equals(methodName) || (typeLength = (types = method.getParameterTypes()).length) != argsLength) continue;
            boolean same = true;
            for (int i = 0; i < typeLength; ++i) {
                if (types[i].equals(argsClass[i])) continue;
                same = false;
                break;
            }
            if (!same) continue;
            return method;
        }
        throw new NoSuchMethodException(methodName);
    }

    public static Method getGetterMethod(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return ObjectUtils.getGetterMethod(bean.getClass(), name);
    }

    public static Method getGetterMethod(Class cl, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = ObjectUtils.getGetterMethodIfExist(cl, name);
        if (method == null) {
            throw new NoSuchMethodException(name);
        }
        return method;
    }

    public static Method getGetterMethodIfExist(Class cl, String name) {
        Method[] list = ObjectUtils.getMethods(cl);
        String pName = StringUtils.upperCaseFirstChar(name);
        StringBuilder sb = new StringBuilder();
        String isMethod = sb.append("is").append(pName).toString();
        sb.setLength(0);
        String getMethod = sb.append("get").append(pName).toString();
        Method method = null;
        for (Method loopMethod : list) {
            if (loopMethod.getParameterTypes().length != 0) continue;
            String methodName = loopMethod.getName();
            if (methodName.equals(getMethod)) {
                method = loopMethod;
                break;
            }
            if (!methodName.equals(isMethod)) continue;
            method = loopMethod;
            break;
        }
        return method;
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = ObjectUtils.getGetterMethodIfExist(bean.getClass(), name);
        if (method == null) {
            return null;
        }
        return method.invoke(bean, EMPTY_OBJECT_ARRAY);
    }

    public static Method getSetterMethod(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return ObjectUtils.getSetterMethod(bean.getClass(), name);
    }

    public static Method getSetterMethod(Class cl, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = ObjectUtils.getSetterMethodIfExist(cl, name);
        if (method == null) {
            throw new NoSuchMethodException(name);
        }
        return method;
    }

    public static Method getSetterMethodIfExist(Class cl, String name) {
        Method[] list = ObjectUtils.getMethods(cl);
        String getMethod = "set" + StringUtils.upperCaseFirstChar(name);
        Method method = null;
        for (Method loopMethod : list) {
            String methodName;
            if (loopMethod.getParameterTypes().length != 1 || !(methodName = loopMethod.getName()).equals(getMethod)) continue;
            method = loopMethod;
            break;
        }
        return method;
    }

    private static Object tranfTypeOfParam(Object parameterValue, Class parameterType) {
        if (parameterValue == null) {
            return null;
        }
        if (parameterValue instanceof String) {
            String valueString = (String)parameterValue;
            if (valueString.equalsIgnoreCase("null")) {
                valueString = "";
            }
            valueString = StringUtils.rightTrim(valueString);
            if (parameterType == Timestamp.class) {
                DateTime d = DataUtils.getDateTime(valueString);
                parameterValue = d == null ? null : new Timestamp(d.getTime());
            } else if (parameterType == java.util.Date.class) {
                DateTime d = DataUtils.getDateTime(valueString);
                parameterValue = d == null ? null : d;
            } else if (parameterType == Double.class) {
                parameterValue = valueString == null || valueString.equals("") ? null : Double.valueOf(DataUtils.correctNumber(valueString));
            } else if (parameterType == Long.class) {
                parameterValue = valueString == null || valueString.equals("") ? null : Long.valueOf(DataUtils.correctNumber(valueString));
            } else if (parameterType == Integer.class) {
                parameterValue = valueString == null || valueString.equals("") ? null : Integer.valueOf(DataUtils.correctNumber(valueString));
            }
        }
        return parameterValue;
    }

    public static void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = ObjectUtils.getSetterMethodIfExist(bean.getClass(), name);
        if (method == null) {
            return;
        }
        value = ObjectUtils.tranfTypeOfParam(value, method.getParameterTypes()[0]);
        try {
            method.invoke(bean, value);
        }
        catch (IllegalArgumentException e) {
            value = ObjectUtils.tranfTypeOfParam("" + value, method.getParameterTypes()[0]);
            method.invoke(bean, value);
        }
    }

    public static Class getGetterType(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = ObjectUtils.getGetterMethodIfExist(bean.getClass(), name);
        if (method == null) {
            return null;
        }
        return method.getReturnType();
    }

    public static String getString(Object obj, String fieldName) {
        return ObjectUtils.convert2String(ObjectUtils.getFieldValue(obj, fieldName));
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        String methodNameTemp = "get" + fieldName;
        Object value = null;
        Method[] methondArr = obj.getClass().getMethods();
        Method m = null;
        for (int k = 0; k < methondArr.length; ++k) {
            if (!methondArr[k].getName().equalsIgnoreCase(methodNameTemp)) continue;
            m = methondArr[k];
            break;
        }
        if (m != null) {
            try {
                value = m.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                value = null;
            }
        }
        return value;
    }

    public static Object getFieldValueToVo(Object obj, String fieldName) throws Exception {
        if (obj == null) {
            return null;
        }
        Object value = null;
        if (ObjectUtils.isIdElement(obj, fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1))) {
            Object idObj = ObjectUtils.getObjectIdAndNew(obj);
            Method m = null;
            if (idObj != null) {
                String methodNameTemp = "get" + fieldName;
                Method[] methondArr = idObj.getClass().getMethods();
                for (int k = 0; k < methondArr.length; ++k) {
                    if (!methondArr[k].getName().equalsIgnoreCase(methodNameTemp)) continue;
                    m = methondArr[k];
                    break;
                }
                if (m != null) {
                    try {
                        value = m.invoke(idObj, new Object[0]);
                    }
                    catch (Exception e) {
                        value = null;
                    }
                }
            }
        } else {
            String methodNameTemp = "get" + fieldName;
            Method[] methondArr = obj.getClass().getMethods();
            Method m = null;
            for (int k = 0; k < methondArr.length; ++k) {
                if (!methondArr[k].getName().equalsIgnoreCase(methodNameTemp)) continue;
                m = methondArr[k];
                break;
            }
            if (m != null) {
                try {
                    value = m.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    value = null;
                }
            }
        }
        return value;
    }

    private static String convert2String(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        String fieldValue = null;
        if (String.class == type) {
            fieldValue = (String)obj;
        } else if (DateTime.class == type || java.util.Date.class == type || type == Timestamp.class) {
            if (type == java.util.Date.class) {
                fieldValue = ((java.util.Date)obj).toString();
            } else if (type == Timestamp.class) {
                fieldValue = ((Timestamp)obj).toString();
            } else if (type == Date.class) {
                fieldValue = ((Date)obj).toString();
            }
        } else {
            fieldValue = type == Integer.class ? ((Integer)obj).toString() : (type == Long.class ? ((Long)obj).toString() : (type == Float.class ? ((Float)obj).toString() : (type == Double.class ? ((Double)obj).toString() : (type == BigDecimal.class ? ((BigDecimal)obj).toString() : (type == Boolean.class ? ((Boolean)obj).toString() : null)))));
        }
        return fieldValue;
    }

    public static Long getLong(Object obj, String fieldName) {
        return ObjectUtils.convert2Long(ObjectUtils.getFieldValue(obj, fieldName));
    }

    public static Long convert2Long(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        Long fieldValue = null;
        fieldValue = String.class == type ? Long.valueOf((String)obj) : (DateTime.class == type || java.util.Date.class == type ? Long.valueOf(((java.util.Date)obj).getTime()) : (type == Integer.class ? Long.valueOf(((Integer)obj).intValue()) : (type == Long.class ? (Long)obj : (type == Float.class ? Long.valueOf(((Float)obj).longValue()) : (type == Double.class ? Long.valueOf(((Double)obj).longValue()) : (type == BigDecimal.class ? Long.valueOf(((BigDecimal)obj).longValue()) : (type == Boolean.class ? ((Boolean)obj != false ? Long.valueOf(1L) : Long.valueOf(0L)) : null)))))));
        return fieldValue;
    }

    public static Double getDouble(Object obj, String fieldName) {
        return ObjectUtils.convert2Double(ObjectUtils.getFieldValue(obj, fieldName));
    }

    public static Double convert2Double(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        Double fieldValue = null;
        fieldValue = String.class == type ? Double.valueOf((String)obj) : (DateTime.class == type || java.util.Date.class == type ? Double.valueOf(Long.valueOf(((java.util.Date)obj).getTime()).intValue()) : (type == Integer.class ? Double.valueOf(((Integer)obj).intValue()) : (type == Long.class ? Double.valueOf(((Long)obj).doubleValue()) : (type == Float.class ? Double.valueOf(((Float)obj).floatValue()) : (type == Double.class ? (Double)obj : (type == BigDecimal.class ? Double.valueOf(((BigDecimal)obj).doubleValue()) : (type == Boolean.class ? ((Boolean)obj != false ? Double.valueOf(1.0) : Double.valueOf(0.0)) : null)))))));
        return fieldValue;
    }

    public static void setFieldValue(Object obj, String fieldName, Object fieldValue) {
        String methodNameSET = "set" + fieldName;
        String methodNameGET = "get" + fieldName;
        Method[] methondArr = obj.getClass().getMethods();
        Method m = null;
        Class<?> type = null;
        for (int k = 0; k < methondArr.length; ++k) {
            if (methondArr[k].getName().equalsIgnoreCase(methodNameSET)) {
                m = methondArr[k];
            } else if (methondArr[k].getName().equalsIgnoreCase(methodNameGET)) {
                type = methondArr[k].getReturnType();
            }
            if (m != null && type != null) break;
        }
        if (m != null) {
            if (String.class == type) {
                fieldValue = (String)fieldValue;
            } else if (DateTime.class == type || java.util.Date.class == type || type == Timestamp.class) {
                fieldValue = type == java.util.Date.class ? new DateTime((java.util.Date)fieldValue, 17) : (type == Timestamp.class ? new DateTime(((Timestamp)fieldValue).toString()) : (type == Date.class ? new DateTime((Date)fieldValue, 17) : (type == DateTime.class ? new DateTime((DateTime)fieldValue, 17) : new DateTime((java.util.Date)fieldValue, 17))));
            } else if (type == Integer.class) {
                fieldValue = ObjectUtils.convert2Integer(fieldValue);
            } else if (type == Long.class) {
                fieldValue = ObjectUtils.convert2Long(fieldValue);
            } else if (type == Float.class) {
                fieldValue = ObjectUtils.convert2Float(fieldValue);
            } else if (type == BigDecimal.class) {
                fieldValue = ObjectUtils.convert2Integer(fieldValue);
            } else if (type == Boolean.class) {
                fieldValue = ObjectUtils.convert2Boolean(fieldValue);
            } else if (type == Double.class) {
                fieldValue = ObjectUtils.convert2Double(fieldValue);
            }
            try {
                m.invoke(obj, fieldValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Boolean getBoolean(Object obj, String fieldName) {
        return ObjectUtils.convert2Boolean(ObjectUtils.getFieldValue(obj, fieldName));
    }

    public static DateTime convert2DateTime(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        DateTime fieldValue = null;
        if (String.class == type) {
            fieldValue = new DateTime((String)obj);
        } else if (DateTime.class == type || java.util.Date.class == type || type == Timestamp.class) {
            fieldValue = type == java.util.Date.class ? new DateTime((java.util.Date)obj, 17) : (type == Timestamp.class ? new DateTime(((Timestamp)obj).toString()) : (type == Date.class ? new DateTime((Date)obj, 17) : (type == DateTime.class ? new DateTime((DateTime)obj, 17) : new DateTime((java.util.Date)obj, 17))));
        } else if (type == Integer.class) {
            fieldValue = new DateTime(((Integer)obj).toString());
        } else if (type == Long.class) {
            fieldValue = new DateTime(((Long)obj).toString());
        } else if (type == Float.class) {
            fieldValue = new DateTime(((Float)obj).toString());
        } else if (type == Double.class) {
            fieldValue = new DateTime(((Double)obj).toString());
        } else if (type == BigDecimal.class) {
            fieldValue = new DateTime(((BigDecimal)obj).toString());
        } else if (type != Boolean.class) {
            fieldValue = null;
        }
        return fieldValue;
    }

    public static Integer convert2Integer(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        Integer fieldValue = null;
        fieldValue = String.class == type ? Integer.valueOf((String)obj) : (DateTime.class == type || java.util.Date.class == type ? Integer.valueOf(Long.valueOf(((java.util.Date)obj).getTime()).intValue()) : (type == Integer.class ? (Integer)obj : (type == Long.class ? Integer.valueOf(((Long)obj).intValue()) : (type == Float.class ? Integer.valueOf(((Float)obj).intValue()) : (type == Double.class ? Integer.valueOf(((Double)obj).intValue()) : (type == BigDecimal.class ? Integer.valueOf(((BigDecimal)obj).intValue()) : (type == Boolean.class ? ((Boolean)obj != false ? Integer.valueOf(1) : Integer.valueOf(0)) : null)))))));
        return fieldValue;
    }

    public static Float convert2Float(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        Float fieldValue = null;
        fieldValue = String.class == type ? Float.valueOf((String)obj) : (DateTime.class == type || java.util.Date.class == type ? Float.valueOf(Long.valueOf(((java.util.Date)obj).getTime()).intValue()) : (type == Integer.class ? Float.valueOf(((Integer)obj).intValue()) : (type == Long.class ? Float.valueOf(((Long)obj).intValue()) : (type == Float.class ? (Float)obj : (type == Double.class ? Float.valueOf(((Double)obj).intValue()) : (type == BigDecimal.class ? Float.valueOf(((BigDecimal)obj).intValue()) : (type == Boolean.class ? ((Boolean)obj != false ? Float.valueOf(1.0f) : Float.valueOf(0.0f)) : null)))))));
        return fieldValue;
    }

    public static Boolean convert2Boolean(Object obj) {
        String value;
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        Boolean fieldValue = null;
        fieldValue = String.class == type ? ("0".equals(value = (String)obj) ? Boolean.valueOf(false) : ("1".equals(value) ? Boolean.valueOf(true) : ("false".equals(value) ? Boolean.valueOf(false) : ("true".equals(value) ? Boolean.valueOf(true) : Boolean.valueOf(false))))) : (DateTime.class == type || java.util.Date.class == type ? Boolean.valueOf(false) : (type == Integer.class ? ((Integer)obj > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)) : (type == Long.class ? (((Long)obj).intValue() > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)) : (type == Float.class ? (((Float)obj).intValue() > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)) : (type == Double.class ? (((Double)obj).intValue() > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)) : (type == BigDecimal.class ? (((BigDecimal)obj).intValue() > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)) : (type == Boolean.class ? (Boolean)obj : null)))))));
        return fieldValue;
    }

    public static boolean isMethodValid(Object obj, String methodName) {
        Method[] methondArr = obj.getClass().getMethods();
        for (int k = 0; k < methondArr.length; ++k) {
            if (!methondArr[k].getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public static void setNoToObject(Map valueMap, Object obj) throws Exception {
        if (valueMap != null && obj != null) {
            Iterator iterator = valueMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object idObj;
                boolean isExistID = true;
                String pName = ObjectUtils.convert2String(iterator.next());
                Object pValue = valueMap.get(pName);
                String pNameGet = "get" + StringUtils.upperCaseFirstChar(pName);
                if (ObjectUtils.isMethodValid(obj, "getId") && ObjectUtils.isMethodValid(idObj = ObjectUtils.getObjectIdAndNew(obj), pNameGet)) {
                    ObjectUtils.setProperty(idObj, pName, pValue);
                    ObjectUtils.setProperty(obj, "id", idObj);
                    isExistID = false;
                }
                if (!isExistID || !ObjectUtils.isMethodValid(obj, pNameGet)) continue;
                ObjectUtils.setProperty(obj, pName, pValue);
            }
        }
    }

    public static String getFieldType(Object obj, String fieldName) {
        String name;
        int i;
        if (obj == null) {
            return null;
        }
        String type = null;
        Field[] fields = obj.getClass().getDeclaredFields();
        for (i = 0; i < fields.length; ++i) {
            name = fields[i].getName();
            if (!name.equals(fieldName)) continue;
            type = fields[i].getType().getName();
        }
        if (type == null && obj.getClass().getSuperclass() != null) {
            fields = obj.getClass().getSuperclass().getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                name = fields[i].getName();
                if (!name.equals(fieldName)) continue;
                type = fields[i].getType().getName();
                break;
            }
        }
        return type;
    }

    public static Object getObjectIdAndNew(Object obj) throws Exception {
        Object idObj = null;
        if (ObjectUtils.isMethodValid(obj, "getId") && (idObj = ObjectUtils.getFieldValue(obj, "id")) == null) {
            String className = ObjectUtils.getFieldType(obj, "id");
            Class<?> objClass = Class.forName(className);
            idObj = objClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return idObj;
    }

    public static boolean isIdElement(Object obj, String eleName) throws Exception {
        List<String> fieldNameList;
        boolean isTrue = false;
        Object idObj = ObjectUtils.getObjectIdAndNew(obj);
        if (idObj != null && (fieldNameList = ObjectUtils.getAllFieldName(idObj.getClass())).contains(eleName)) {
            isTrue = true;
        }
        return isTrue;
    }

    public static String getDtoName(Object objDto) {
        String dtoName = "";
        if (objDto == null) {
            objDto = "";
        }
        String dtoNameStrs = objDto.getClass().getName();
        dtoName = ObjectUtils.changeFirstLetter(dtoNameStrs);
        return dtoName;
    }

    public static String changeFirstLetter(String oriStrs) {
        Object resultStrs = oriStrs.substring(oriStrs.lastIndexOf("."));
        if (resultStrs == null) {
            resultStrs = "";
        }
        if (!"".equals(resultStrs) && ((String)resultStrs).length() > 2) {
            resultStrs = ((String)resultStrs).substring(1, 2).toLowerCase() + ((String)resultStrs).substring(2);
        } else if (((String)resultStrs).length() == 1) {
            resultStrs = ((String)resultStrs).substring(1, 2).toLowerCase();
        }
        return resultStrs;
    }

    public static List getListByCondition(List list, String ... params) throws Exception {
        ArrayList resultList = null;
        if (list != null && list.size() > 0) {
            List<String> paramList;
            List<String> list2 = paramList = params != null ? Arrays.asList(params) : null;
            if (paramList != null && paramList.size() > 0) {
                resultList = new ArrayList();
                for (Object obj : list) {
                    boolean isTrue = true;
                    for (String str : paramList) {
                        if ("".equals(str)) continue;
                        String[] name_value = str.split("_");
                        String name = name_value[0];
                        String value = name_value[1];
                        Object idObj = ObjectUtils.getObjectIdAndNew(obj);
                        if (value.equals(ObjectUtils.getFieldValue(obj, name)) || value.equals(ObjectUtils.getFieldValue(idObj, name))) continue;
                        isTrue = false;
                        break;
                    }
                    if (!isTrue) continue;
                    resultList.add(obj);
                }
            }
        }
        return resultList;
    }

    public static void setFieldValueToVo(Object obj, String fieldName, Object fieldValue) throws Exception {
        if (ObjectUtils.isIdElement(obj, fieldName)) {
            Object idObj = ObjectUtils.getObjectIdAndNew(obj);
            ObjectUtils.setFieldValue(idObj, fieldName, fieldValue);
            ObjectUtils.setFieldValue(obj, "id", idObj);
        } else {
            ObjectUtils.setFieldValue(obj, fieldName, fieldValue);
        }
    }
}

