/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectHelper {
    private static final Logger log = LoggerFactory.getLogger(ReflectHelper.class);

    public static Object getFieldValue(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        Field targetField = ReflectHelper.getTargetField(obj.getClass(), fieldName);
        try {
            return FieldUtils.readField((Field)targetField, (Object)obj, (boolean)true);
        }
        catch (IllegalAccessException e) {
            log.warn(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static Field getTargetField(Class<?> targetClass, String fieldName) {
        Field field = null;
        try {
            if (targetClass == null) {
                return field;
            }
            if (Object.class.equals(targetClass)) {
                return field;
            }
            field = FieldUtils.getDeclaredField(targetClass, (String)fieldName, (boolean)true);
            if (field == null) {
                field = ReflectHelper.getTargetField(targetClass.getSuperclass(), fieldName);
            }
        }
        catch (Exception e) {
            log.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        return field;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        if (null == obj) {
            return;
        }
        Field targetField = ReflectHelper.getTargetField(obj.getClass(), fieldName);
        try {
            FieldUtils.writeField((Field)targetField, (Object)obj, (Object)value);
        }
        catch (IllegalAccessException e) {
            log.warn(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

