/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StringUtils {
    private static final Log logger = LogFactory.getLog(StringUtils.class);
    private static String defaultCharset = System.getProperty("file.encoding");

    private StringUtils() {
    }

    public static String getDefaultCharset() {
        return defaultCharset;
    }

    public static void setDefaultCharset(String defaultCharset) {
        StringUtils.defaultCharset = defaultCharset;
    }

    public static String newString(String value, int length) {
        if (value == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            buffer.append(value);
        }
        return buffer.toString();
    }

    public static String newString(char inChr, int length) {
        return StringUtils.newString(String.valueOf(inChr), length);
    }

    public static String copyString(String str, int copyTimes) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < copyTimes; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static int getBytesLength(String str) {
        if (str == null) {
            return -1;
        }
        return str.getBytes().length;
    }

    public static int indexOf(String str, String subStr, int startIndex, int occurrenceTimes) {
        int foundCount = 0;
        int index = startIndex;
        if (occurrenceTimes <= 0) {
            return -1;
        }
        if (str.length() - 1 < startIndex) {
            return -1;
        }
        if ("".equals(subStr)) {
            return 0;
        }
        int substrLength = subStr.length();
        while (foundCount < occurrenceTimes) {
            if ((index = str.indexOf(subStr, index)) == -1) {
                return -1;
            }
            ++foundCount;
            index += substrLength;
        }
        return index - substrLength;
    }

    public static int indexOf(String str, String subStr, int occurrenceTimes) {
        return StringUtils.indexOf(str, subStr, 0, occurrenceTimes);
    }

    public static int indexOf(String str, String subStr, int fromIndex, boolean caseSensitive) {
        if (!caseSensitive) {
            return str.toLowerCase().indexOf(subStr.toLowerCase(), fromIndex);
        }
        return str.indexOf(subStr, fromIndex);
    }

    public static String replace(String str, String searchStr, String replaceStr, boolean caseSensitive) {
        int i = 0;
        int j = 0;
        if (str == null) {
            return null;
        }
        if ("".equals(str)) {
            return "";
        }
        if (searchStr == null || searchStr.equals("")) {
            return str;
        }
        String newReplaceStr = replaceStr;
        if (replaceStr == null) {
            newReplaceStr = "";
        }
        StringBuilder buffer = new StringBuilder();
        while ((j = StringUtils.indexOf(str, searchStr, i, caseSensitive)) > -1) {
            buffer.append(str.substring(i, j));
            buffer.append(newReplaceStr);
            i = j + searchStr.length();
        }
        buffer.append(str.substring(i, str.length()));
        return buffer.toString();
    }

    public static String replace(String str, String searchStr, String replaceStr) {
        return StringUtils.replace(str, searchStr, replaceStr, true);
    }

    public static String replace(String str, char searchChar, String replaceStr) {
        return StringUtils.replace(str, String.valueOf(searchChar), replaceStr, true);
    }

    public static String replace(String str, int beginIndex, String replaceStr) {
        if (str == null) {
            return null;
        }
        String newReplaceStr = replaceStr;
        if (replaceStr == null) {
            newReplaceStr = "";
        }
        StringBuilder buffer = new StringBuilder(str.substring(0, beginIndex));
        buffer.append(newReplaceStr);
        buffer.append(str.substring(beginIndex + newReplaceStr.length()));
        return buffer.toString();
    }

    public static String[] split(String originalString, int splitByteLength) {
        return StringUtils.split(originalString, splitByteLength, defaultCharset);
    }

    public static String[] split(String originalString, int splitByteLength, String charsetName) {
        if (originalString == null) {
            return new String[0];
        }
        if ("".equals(originalString)) {
            return new String[0];
        }
        if (originalString.trim().equals("")) {
            return new String[]{""};
        }
        if (splitByteLength <= 1) {
            return new String[]{originalString};
        }
        int size = originalString.length();
        ArrayList<String> strList = new ArrayList<String>();
        try {
            int count = 0;
            int start = 0;
            int len = 0;
            for (int i = 0; i < size; ++i) {
                len = String.valueOf(originalString.charAt(i)).getBytes(charsetName).length;
                if ((count += len) == splitByteLength) {
                    strList.add(originalString.substring(start, i + 1));
                    count = 0;
                    start = i + 1;
                    continue;
                }
                if (count <= splitByteLength) continue;
                strList.add(originalString.substring(start, i));
                count = len;
                start = i;
            }
            if (start < size) {
                strList.add(originalString.substring(start));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        String[] arrReturn = new String[strList.size()];
        strList.toArray(arrReturn);
        return arrReturn;
    }

    public static String[] split(String originalString, String delimiterString) {
        String strTemp;
        int index = 0;
        String[] returnArray = null;
        int length = 0;
        if (originalString == null || delimiterString == null || "".equals(originalString)) {
            return new String[0];
        }
        if ("".equals(originalString) || "".equals(delimiterString) || originalString.length() < delimiterString.length()) {
            return new String[]{originalString};
        }
        for (strTemp = originalString; strTemp != null && !strTemp.equals("") && (index = strTemp.indexOf(delimiterString)) != -1; strTemp = strTemp.substring(index + delimiterString.length())) {
            ++length;
        }
        returnArray = new String[++length];
        strTemp = originalString;
        for (int i = 0; i < length - 1; ++i) {
            index = strTemp.indexOf(delimiterString);
            returnArray[i] = strTemp.substring(0, index);
            strTemp = strTemp.substring(index + delimiterString.length());
        }
        returnArray[length - 1] = strTemp;
        return returnArray;
    }

    public static String rightTrim(String str) {
        if (str == null) {
            return "";
        }
        int length = str.length();
        for (int i = length - 1; i >= 0 && str.charAt(i) == ' '; --i) {
            --length;
        }
        return str.substring(0, length);
    }

    public static String leftTrim(String str) {
        if (str == null) {
            return "";
        }
        int start = 0;
        int n = str.length();
        for (int i = 0; i < n && str.charAt(i) == ' '; ++i) {
            ++start;
        }
        return str.substring(start);
    }

    public static String absoluteTrim(String str) {
        return StringUtils.replace(str, " ", "");
    }

    public static String lowerCase(String str, int beginIndex, int endIndex) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(str.substring(0, beginIndex));
        buffer.append(str.substring(beginIndex, endIndex).toLowerCase());
        buffer.append(str.substring(endIndex));
        return buffer.toString();
    }

    public static String upperCase(String str, int beginIndex, int endIndex) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(str.substring(0, beginIndex));
        buffer.append(str.substring(beginIndex, endIndex).toUpperCase());
        buffer.append(str.substring(endIndex));
        return buffer.toString();
    }

    public static String lowerCaseFirstChar(String iString) {
        if (iString == null || iString.length() < 1) {
            throw new IllegalArgumentException("String must have at least one character.");
        }
        return new StringBuilder(iString.length()).append(iString.substring(0, 1).toLowerCase()).append(iString.substring(1)).toString();
    }

    public static String upperCaseFirstChar(String iString) {
        if (iString == null || iString.length() < 1) {
            throw new IllegalArgumentException("String must have at least one character.");
        }
        return new StringBuilder(iString.length()).append(iString.substring(0, 1).toUpperCase()).append(iString.substring(1)).toString();
    }

    public static int timesOf(String str, String subStr) {
        int foundCount = 0;
        if ("".equals(subStr)) {
            return 0;
        }
        int fromIndex = str.indexOf(subStr);
        while (fromIndex != -1) {
            ++foundCount;
            fromIndex = str.indexOf(subStr, fromIndex + subStr.length());
        }
        return foundCount;
    }

    public static int timesOf(String str, char ch) {
        int foundCount = 0;
        int fromIndex = str.indexOf(ch);
        while (fromIndex != -1) {
            ++foundCount;
            fromIndex = str.indexOf(ch, fromIndex + 1);
        }
        return foundCount;
    }

    public static Map<String, String> toMap(String str, String splitString) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] values = StringUtils.split(str, splitString);
        String k = "";
        String v = "";
        for (int i = 0; i < values.length; ++i) {
            String tempValue = values[i];
            int pos = tempValue.indexOf(61);
            k = "";
            v = "";
            if (pos > -1) {
                k = tempValue.substring(0, pos);
                v = tempValue.substring(pos + splitString.length());
            } else {
                k = tempValue;
            }
            map.put(k, v);
        }
        return map;
    }

    public static String native2ascii(String str) {
        char[] ca = str.toCharArray();
        StringBuilder buffer = new StringBuilder(ca.length * 6);
        for (int x = 0; x < ca.length; ++x) {
            char a = ca[x];
            if (a > '\u00ff') {
                buffer.append("\\u").append(Integer.toHexString(a));
                continue;
            }
            buffer.append(a);
        }
        return buffer.toString();
    }

    public static boolean hasText(String str) {
        return null != str && !"".equals(str);
    }

    public static String concat(Object ... sources) {
        if (sources == null) {
            return "";
        }
        if (sources.length == 1) {
            return String.valueOf(sources[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : sources) {
            if (o == null) continue;
            sb.append(o);
        }
        return sb.toString();
    }

    public static boolean isHasFuzzySign(String str) {
        return str.indexOf("*") > -1 || str.indexOf("%") > -1 || str.indexOf("?") > -1;
    }

    @Deprecated
    public static boolean isNotEmpty(List<?> list) {
        return list != null && list.size() > 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !"".equals(str);
    }

    public static boolean isEmpty(String str) {
        return !StringUtils.isNotEmpty(str);
    }

    public static String replaceFuzzySign(String str) {
        if (StringUtils.isNotEmpty(str)) {
            str = str.replace("*", "%");
            str = str.replace("?", "%");
            str = str.replace("%%", "%");
        }
        return str;
    }

    public static void genConditionSqlByStringField(StringBuffer sqlAppend, List<Object> params, String filedValue, String filedNameInDb) {
        if (StringUtils.isNotEmpty(filedValue)) {
            if (StringUtils.isHasFuzzySign(filedValue)) {
                sqlAppend.append(" and " + filedNameInDb + " like ?");
                params.add(StringUtils.replaceFuzzySign(filedValue.trim()));
            } else {
                sqlAppend.append(" and " + filedNameInDb + " = ?");
                params.add(filedValue.trim());
            }
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String[] values = StringUtils.split(new String("\u4e2d\u56fd\u4eba\u6c11\u4fdd\u9669\u516c\u53f8\u4e24\u5343\u5e74\u7279\u522b\u6761\u6b3e".getBytes("GBK"), "GB18030"), 2);
        for (int i = 0; i < values.length; ++i) {
            logger.info((Object)(i + ":\t" + values[i]));
        }
    }
}

