/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import com.cntaiping.fsc.core.model.BaseNode;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TreeUtils.class);

    public static <T extends BaseNode> List<T> buildTree(List<T> list, boolean expandAll) {
        return TreeUtils.buildTree(list, expandAll, null);
    }

    @Deprecated
    public static <T extends BaseNode> List<T> buildTree(List<T> list, boolean expandAll, boolean recursive) {
        if (recursive) {
            return TreeUtils.buildTree(list, expandAll);
        }
        return TreeUtils.buildTree1(list, expandAll);
    }

    @Deprecated
    public static <T extends BaseNode> List<T> buildTree1(List<T> list, boolean notExpandAll) {
        LinkedList<BaseNode> nodeList = new LinkedList<BaseNode>();
        int count = 0;
        LOG.debug("--\u5f00\u59cb\u6784\u5efa\u6811\u72b6\u7ed3\u6784\uff08\u65b9\u6cd51\uff09\uff0c\u96c6\u5408\u5927\u5c0f: {}", (Object)list.size());
        long begin = System.currentTimeMillis();
        HashSet<String> addedNodeIds = new HashSet<String>();
        for (BaseNode node1 : list) {
            if (addedNodeIds.size() == list.size()) break;
            boolean added = false;
            for (BaseNode node2 : list) {
                ++count;
                if (addedNodeIds.size() == list.size()) break;
                if (!StringUtils.isNotBlank((CharSequence)node1.getpId()) || !node1.getpId().equals(node2.getId())) continue;
                added = true;
                if (notExpandAll) {
                    node2.setIsExpanded(Short.valueOf((short)0));
                }
                if (node2.getSubNodes().contains(node1)) break;
                node2.setEntityNum(node2.getEntityNum() + node1.getEntityNum());
                node2.getSubNodes().add(node1);
                addedNodeIds.add(node2.getId());
                break;
            }
            if (added) continue;
            nodeList.add(node1);
            addedNodeIds.add(node1.getId());
            if (!notExpandAll) continue;
            node1.setIsExpanded(Short.valueOf((short)0));
        }
        long end = System.currentTimeMillis();
        LOG.debug("--\u7ed3\u675f\u6784\u5efa\u6811\u72b6\u7ed3\u6784\uff08\u65b9\u6cd51\uff09\uff0c\u8017\u65f6: {} ms, \u8fd0\u7b97\u6b21\u6570: {} \u6b21", (Object)(end - begin), (Object)count);
        return nodeList;
    }

    public static <T extends BaseNode> List<T> buildTree(List<T> list, boolean notExpandAll, T superTreeNode) {
        LinkedList<BaseNode> nodeTree = new LinkedList<BaseNode>();
        if (superTreeNode != null) {
            nodeTree.add(superTreeNode);
        }
        Counter counter = new Counter();
        LOG.debug("--\u5f00\u59cb\u6784\u5efa\u6811\u72b6\u7ed3\u6784\uff08\u65b9\u6cd52\uff09\uff0c\u96c6\u5408\u5927\u5c0f: {}", (Object)list.size());
        long begin = System.currentTimeMillis();
        List unAddedNodeList = list.stream().filter(node -> node.getNodeLevel() > 0).collect(Collectors.toList());
        for (BaseNode rootNode : list) {
            counter.addNum();
            if (!StringUtils.isBlank((CharSequence)rootNode.getpId()) && rootNode.getNodeLevel() != 0) continue;
            if (notExpandAll) {
                rootNode.setIsExpanded(Short.valueOf((short)0));
            }
            if (superTreeNode != null) {
                TreeUtils.addSubNode(rootNode, unAddedNodeList, 1, counter);
                rootNode.setpId(superTreeNode.getId());
                superTreeNode.addSubNode(rootNode);
                superTreeNode.setEntityNum(superTreeNode.getEntityNum() + rootNode.getEntityNum());
                continue;
            }
            nodeTree.add(TreeUtils.addSubNode(rootNode, unAddedNodeList, 1, counter));
        }
        if (unAddedNodeList != null) {
            unAddedNodeList.clear();
            unAddedNodeList = null;
        }
        long end = System.currentTimeMillis();
        LOG.debug("--\u7ed3\u675f\u6784\u5efa\u6811\u72b6\u7ed3\u6784\uff08\u65b9\u6cd52\uff09\uff0c\u8017\u65f6: {} ms, \u8fd0\u7b97\u6b21\u6570: {} \u6b21", (Object)(end - begin), (Object)counter.getNum());
        return nodeTree;
    }

    public static <T extends BaseNode> T addSubNode(T parentNode, List<T> nodeList, int currentLevel, Counter counter) {
        if (currentLevel != parentNode.getNodeLevel() + 1) {
            return parentNode;
        }
        List unAddedNodeList = nodeList.stream().filter(node -> node.getNodeLevel() > currentLevel).collect(Collectors.toList());
        counter.addNum(nodeList.size());
        for (BaseNode subNode : nodeList) {
            counter.addNum();
            if (subNode.getNodeLevel() != currentLevel || !StringUtils.isNotBlank((CharSequence)subNode.getpId()) || !subNode.getpId().equals(parentNode.getId())) continue;
            if (subNode.getIsLeaf() == 1) {
                parentNode.addSubNode(TreeUtils.addSubNode(subNode, unAddedNodeList, currentLevel + 1, counter));
            } else {
                parentNode.addSubNode(subNode);
            }
            parentNode.setEntityNum(parentNode.getEntityNum() + subNode.getEntityNum());
        }
        if (unAddedNodeList != null) {
            unAddedNodeList.clear();
            unAddedNodeList = null;
        }
        return parentNode;
    }

    private static <T extends BaseNode> List<T> buildTree3(List<T> list, boolean notExpandAll) {
        LinkedList<BaseNode> nodeList = new LinkedList<BaseNode>();
        int count = 0;
        LOG.debug("--\u5f00\u59cb\u6784\u5efa\u6811\u72b6\u7ed3\u6784\uff08\u65b9\u6cd53\uff09\uff0c\u96c6\u5408\u5927\u5c0f: {}", (Object)list.size());
        long begin = System.currentTimeMillis();
        HashSet<String> addedNodeIds = new HashSet<String>();
        for (BaseNode node1 : list) {
            if (addedNodeIds.size() == list.size()) break;
            boolean mark = false;
            for (BaseNode node2 : list) {
                ++count;
                if (addedNodeIds.size() == list.size()) break;
                if (!StringUtils.isNotBlank((CharSequence)node1.getpId()) || !node1.getpId().equals(node2.getId())) continue;
                mark = true;
                if (node2.getIsLeaf() == null || node2.getIsLeaf() != 1) {
                    node2.setIsLeaf(Short.valueOf((short)1));
                }
                if (notExpandAll) {
                    node2.setIsExpanded(Short.valueOf((short)0));
                }
                if (node2.getSubNodes().contains(node1)) break;
                node2.setEntityNum(node2.getEntityNum() + node1.getEntityNum());
                node2.getSubNodes().add(node1);
                addedNodeIds.add(node2.getId());
                break;
            }
            if (mark) continue;
            nodeList.add(node1);
            addedNodeIds.add(node1.getId());
            if (!notExpandAll) continue;
            node1.setIsExpanded(Short.valueOf((short)0));
        }
        long end = System.currentTimeMillis();
        LOG.debug("--\u7ed3\u675f\u6784\u5efa\u6811\u72b6\u7ed3\u6784\uff08\u65b9\u6cd53\uff09\uff0c\u8017\u65f6: {} ms, \u8fd0\u7b97\u6b21\u6570: {} \u6b21", (Object)(end - begin), (Object)count);
        return nodeList;
    }

    public static class Counter {
        private int num = 0;

        public int getNum() {
            return this.num;
        }

        public void setNum(int num) {
            this.num = num;
        }

        public void addNum() {
            ++this.num;
        }

        public void addNum(int num) {
            this.num += num;
        }
    }
}

