create table GG_SEQUENCE
(
  sequence_id        VARCHAR2(32 CHAR) not null,
  sequence_name      VARCHAR2(32 CHAR) not null,
  version            NUMBER(8) default 0 not null,
  seq_no_type        NUMBER(2) default 0 not null,
  INCREASE_TYPE         NUMBER(2) default 0 not null,
  seq_no_length      NUMBER(4) default 16 not null,
  current_no         NUMBER(16) default 1 not null,
  cache_size         NUMBER(8) default 0 not null,
  max_cache_no         NUMBER(16),
  description        VARCHAR2(255 CHAR),
  sequence_rule      VARCHAR2(255 CHAR),
  valid              NUMBER(1) default 1 not null,
  next_reset_date    TIMESTAMP(6),
  create_by          VARCHAR2(32 CHAR),
  create_date        TIMESTAMP(6) default sysdate not null,
  last_modified_by   VARCHAR2(32 CHAR),
  last_modified_date TIMESTAMP(6) default sysdate not null,
  status             NUMBER(2) default 0 not null

);

comment on table GG_SEQUENCE
  is '序列号生成规则配置';
comment on column GG_SEQUENCE.sequence_id
  is '序列ID|主键';
comment on column GG_SEQUENCE.sequence_name
  is '序列名称';
comment on column GG_SEQUENCE.version
  is '版本号';
comment on column GG_SEQUENCE.seq_no_type
  is '序列号类型（0：数值自增长；1：自定义字符串[按规则生成]）';
comment on column GG_SEQUENCE.INCREASE_TYPE
  is '序号增长方式（0：顺序增长；1：按年循环；2：按月循环；3：按日循环；4：分组增长）';
comment on column GG_SEQUENCE.seq_no_length
  is '顺序号长度';
comment on column GG_SEQUENCE.current_no
  is '当前可用号码';
comment on column GG_SEQUENCE.cache_size
  is '每次缓存号码数量';
comment on column GG_SEQUENCE.max_cache_no
  is '当前缓存的最大可用号码';
comment on column GG_SEQUENCE.description
  is '用途描述';
comment on column GG_SEQUENCE.sequence_rule
  is '单号规则表达式（JEXL表达式）';
comment on column GG_SEQUENCE.valid
  is '生效状态。1为有效，0为无效，2为逻辑删除';
comment on column GG_SEQUENCE.next_reset_date
  is '下次重置时间';
comment on column GG_SEQUENCE.create_by
  is '创建人';
comment on column GG_SEQUENCE.create_date
  is '创建时间';
comment on column GG_SEQUENCE.last_modified_by
  is '最后修改人';
comment on column GG_SEQUENCE.last_modified_date
  is '最后修改时间';
comment on column GG_SEQUENCE.status
  is '业务状态（0：未启用；1：启用中；2：已停止）';
create unique index IDX_U_SEQUENCE on GG_SEQUENCE (SEQUENCE_ID, VERSION);
alter table GG_SEQUENCE
  add constraint PK_SEQUENCE_ID primary key (SEQUENCE_ID);


create table GG_SEQUENCE_GROUP
(
  SEQ_GROUP_CODE     VARCHAR2(32 CHAR) not null,
  SEQUENCE_ID        VARCHAR2(32 CHAR) not null,
  seq_no_length      NUMBER(4) default 16 not null,
  current_no     NUMBER(16) default 1 not null,
  cache_size         NUMBER(8) default 0 not null,
  max_cache_no         NUMBER(16)
);

comment on table GG_SEQUENCE_GROUP
  is '序列分组号码表';
comment on column GG_SEQUENCE_GROUP.SEQ_GROUP_CODE
  is '序列分组编码|主键（由序列前缀组成）';
comment on column GG_SEQUENCE_GROUP.SEQUENCE_ID
  is '序列ID';
comment on column GG_SEQUENCE_GROUP.seq_no_length
  is '顺序号长度';
comment on column GG_SEQUENCE_GROUP.current_no
  is '当前可用号码';
comment on column GG_SEQUENCE_GROUP.cache_size
  is '每次缓存号码数量';
comment on column GG_SEQUENCE_GROUP.max_cache_no
  is '当前缓存的最大可用号码';
  
alter table GG_SEQUENCE_GROUP
  add constraint PK_SEQUENCE_G_ID primary key (SEQ_GROUP_CODE);
alter table GG_SEQUENCE_GROUP
  add constraint FK_SEQUENCE_G_SEQ_ID foreign key (SEQUENCE_ID)
  references GG_SEQUENCE (SEQUENCE_ID);

create table GG_SEQUENCE_LOST
(
  ID     VARCHAR2(32 CHAR) not null,
  SEQ_LOST_KEY     VARCHAR2(32 CHAR) not null,
  seq_no      VARCHAR2(32 CHAR) not null
);
  
comment on table GG_SEQUENCE_LOST
  is '序列遗漏号码表';
comment on column GG_SEQUENCE_LOST.ID
  is '逻辑主键（按时间生成用于排序）';
comment on column GG_SEQUENCE_LOST.SEQ_LOST_KEY
  is '序列遗漏编码（序列ID或序列分组编码）';
comment on column GG_SEQUENCE_LOST.seq_no
  is '已生成的单号';

create index IDX_SEQUENCE_LOST on GG_SEQUENCE_LOST (SEQ_LOST_KEY);
alter table GG_SEQUENCE_LOST
  add constraint PK_SEQUENCE_LOST primary key (ID);
  
insert into GG_SEQUENCE (sequence_id, sequence_name, version, seq_no_type, increase_type, seq_no_length, current_no, cache_size, max_cache_no, description, sequence_rule, valid, next_reset_date, create_by, create_date, last_modified_by, last_modified_date, status)
values ('TEST_SEQ_001', '测试自增长序列号', 0, 0, 0, 16, 1, 20, 20, '测试自增长序列号，长整型，16位长度，顺序增长，不循环', null, 1, null, 'admin', to_timestamp('04-09-2018 17:09:23.702000', 'dd-mm-yyyy hh24:mi:ss.ff'), 'admin', to_timestamp('04-09-2018 17:09:23.702000', 'dd-mm-yyyy hh24:mi:ss.ff'), 0);
insert into GG_SEQUENCE (sequence_id, sequence_name, version, seq_no_type, increase_type, seq_no_length, current_no, cache_size, max_cache_no, description, sequence_rule, valid, next_reset_date, create_by, create_date, last_modified_by, last_modified_date, status)
values ('TEST_BIZNO_002', '测试规则序列号2', 0, 1, 0, 6, 1, 20, 20, '测试自定义规则序号号，字符串型，数据号长度为6位，顺序增长，不循环，带''yyyyMMdd''时间前缀', 'DATE_DAY + ''SEQ_NO''', 1, null, 'admin', to_timestamp('04-09-2018 19:51:12.375000', 'dd-mm-yyyy hh24:mi:ss.ff'), 'admin', to_timestamp('04-09-2018 19:51:12.375000', 'dd-mm-yyyy hh24:mi:ss.ff'), 0);
insert into GG_SEQUENCE (sequence_id, sequence_name, version, seq_no_type, increase_type, seq_no_length, current_no, cache_size, max_cache_no, description, sequence_rule, valid, next_reset_date, create_by, create_date, last_modified_by, last_modified_date, status)
values ('TEST_BIZNO_003', '测试规则序列号3', 0, 1, 0, 5, 1, 20, 20, '测试自定义规则序号号，字符串型，数据号长度为6位，顺序增长，不循环，带''yyyyMMddhhmmss''时间前缀', 'DATE_SECOND + ''-'' + ''SEQ_NO''', 1, null, 'admin', to_timestamp('04-09-2018 19:51:12.375000', 'dd-mm-yyyy hh24:mi:ss.ff'), 'admin', to_timestamp('04-09-2018 19:51:12.375000', 'dd-mm-yyyy hh24:mi:ss.ff'), 0);
insert into GG_SEQUENCE (sequence_id, sequence_name, version, seq_no_type, increase_type, seq_no_length, current_no, cache_size, max_cache_no, description, sequence_rule, valid, next_reset_date, create_by, create_date, last_modified_by, last_modified_date, status)
values ('TEST_BIZNO_001', '测试规则序列号1', 0, 1, 0, 10, 1, 20, 20, '测试自定义规则序号号，字符串型，数据号长度为10位，顺序增长，不循环，带''SEQ-''前缀', '''SEQ-'' + ''SEQ_NO''', 1, null, 'admin', to_timestamp('04-09-2018 19:51:12.375000', 'dd-mm-yyyy hh24:mi:ss.ff'), 'admin', to_timestamp('04-09-2018 19:51:12.375000', 'dd-mm-yyyy hh24:mi:ss.ff'), 0);
insert into GG_SEQUENCE (sequence_id, sequence_name, version, seq_no_type, increase_type, seq_no_length, current_no, cache_size, max_cache_no, description, sequence_rule, valid, next_reset_date, create_by, create_date, last_modified_by, last_modified_date, status)
values ('TEST_BIZNO_004', '测试规则序列号4', 0, 1, 3, 6, 1, 20, 20, '测试自定义规则序号号，字符串型，数据号长度为6位，顺序增长，不循环，前缀为动态变量company_code(该字段以键值对形式传入动态变量paramMap中)的第0至2个字符和内置时间变量DATE_DAY（格式为''yyyyMMdd''）', 'company_code.substring(0,2) + ''-'' +  DATE_DAY + ''-'' + ''SEQ_NO''', 1, null, 'admin', to_timestamp('05-09-2018 10:56:26.477000', 'dd-mm-yyyy hh24:mi:ss.ff'), 'admin', to_timestamp('05-09-2018 10:56:26.477000', 'dd-mm-yyyy hh24:mi:ss.ff'), 0);
insert into GG_SEQUENCE (sequence_id, sequence_name, version, seq_no_type, increase_type, seq_no_length, current_no, cache_size, max_cache_no, description, sequence_rule, valid, next_reset_date, create_by, create_date, last_modified_by, last_modified_date, status)
values ('TEST_BIZNO_005', '测试规则序列号5', 0, 1, 4, 6, 1, 20, 20, '测试自定义规则序号号，字符串型，数据号长度为6位，分组增长，不循环，前缀为‘TEST’和内置时间变量DATE_DAY（格式为''yyyyMMdd''）', '''TEST-'' +  DATE_DAY + ''-'' + ''SEQ_NO''', 1, null, 'admin', to_timestamp('05-09-2018 10:56:26.477000', 'dd-mm-yyyy hh24:mi:ss.ff'), 'admin', to_timestamp('05-09-2018 10:56:26.477000', 'dd-mm-yyyy hh24:mi:ss.ff'), 0);
commit;
insert into GG_SEQUENCE_GROUP (seq_group_code, sequence_id, seq_no_length, current_no, cache_size, max_cache_no)
values ('TEST-20180905-SEQ_NO', 'TEST_BIZNO_005', 6, 1, 20, 20);
commit;