/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.config;

import com.cntaiping.fsc.common.config.CommonProperties;
import com.cntaiping.fsc.common.error.GlobalHttpExceptionHandler;
import com.cntaiping.fsc.common.filter.AuditLogRequestFilter;
import com.cntaiping.fsc.common.listener.ApiResourceRegisterListener;
import com.cntaiping.fsc.common.util.BusinessNoUtil;
import com.cntaiping.fsc.common.util.HttpClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={CommonProperties.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class CommonConfig {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CommonProperties commonProperties;

    public CommonConfig() {
        this.LOG.debug("Init Tpcloud CommonConfig.");
    }

    @Bean
    @ConditionalOnBean(name={"jsonRedisTemplate"})
    public ApiResourceRegisterListener apiResourceRegisterListener(RedisTemplate<String, Object> jsonRedisTemplate) {
        this.LOG.debug("Init CommonConfig ApiResourceRegisterListener.");
        return new ApiResourceRegisterListener(jsonRedisTemplate);
    }

    @Primary
    @Bean(name={"loadBalancedRestTemplate"})
    @ConditionalOnMissingBean(name={"loadBalancedRestTemplate"})
    @LoadBalanced
    public RestTemplate loadBalancedRestTemplate(RestTemplateBuilder restTemplateBuilder) {
        this.LOG.debug("Init CommonConfig loadBalancedRestTemplate.");
        return restTemplateBuilder.build();
    }

    @Bean(name={"normalRestTemplate"})
    @ConditionalOnMissingBean(name={"normalRestTemplate"})
    public RestTemplate normalRestTemplate(RestTemplateBuilder restTemplateBuilder) {
        this.LOG.debug("Init CommonConfig normalRestTemplate.");
        return restTemplateBuilder.build();
    }

    @Bean
    public HttpClientUtil httpClientUtil(RestTemplate loadBalancedRestTemplate, @Qualifier(value="normalRestTemplate") RestTemplate normalRestTemplate) {
        return new HttpClientUtil(loadBalancedRestTemplate, normalRestTemplate);
    }

    @Bean
    @ConditionalOnProperty(name={"app.common.enableAuditLog"}, havingValue="true", matchIfMissing=false)
    public AuditLogRequestFilter auditLogRequestFilter() {
        this.LOG.debug("Init CommonConfig AuditLogRequestFilter.");
        return new AuditLogRequestFilter(this.commonProperties);
    }

    @Bean
    @ConditionalOnProperty(name={"app.common.enableBusinessNoUtil"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnBean(value={HttpClientUtil.class})
    public BusinessNoUtil businessNoUtil(RedisTemplate<String, Object> redisTemplate, HttpClientUtil httpClientUtil) {
        this.LOG.debug("Init CommonConfig BusinessNoUtil.");
        return new BusinessNoUtil(redisTemplate, httpClientUtil, this.commonProperties.getSystemApiUrl());
    }

    @RestControllerAdvice
    public class TpGlobalHttpExceptionHandler
    extends GlobalHttpExceptionHandler {
    }
}

