/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.config;

import com.cntaiping.fsc.common.config.CommonProperties;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CommonProperties.class})
@ConditionalOnClass(value={org.springdoc.webmvc.ui.SwaggerConfig.class})
@ConditionalOnBean(value={org.springdoc.webmvc.ui.SwaggerConfig.class})
public class SwaggerConfig {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_PACKAGE = "com.cntaiping.fsc";
    @Autowired
    private CommonProperties commonProperties;

    public SwaggerConfig() {
        this.LOG.debug("Init Tpcloud SwaggerConfig.");
    }

    @Bean
    public GroupedOpenApi groupedOpenApi() {
        this.LOG.debug("Init SwaggerConfig. Create GroupedOpenApi ");
        String apiBasePackage = this.commonProperties.getApiBasePackage();
        apiBasePackage = StringUtils.isEmpty((CharSequence)apiBasePackage) ? DEFAULT_PACKAGE : apiBasePackage;
        return GroupedOpenApi.builder().group("TphwSwagger").packagesToScan(new String[]{apiBasePackage}).pathsToMatch(new String[]{"/**"}).build();
    }

    private OpenAPI openApi() {
        Info info = new Info().title("\u5fae\u670d\u52a1 API\u5feb\u901f\u8c03\u8bd5\u9875\u9762").description("\u5fae\u670d\u52a1\u8c03\u8bd5\u9875\u9762\uff0c\u4ec5\u4f9b\u5f00\u53d1\u73af\u5883\u4f7f\u7528\uff0c\u5176\u4ed6\u73af\u5883\u7981\u6b62\u542f\u52a8\uff0c\u8bf7\u8bbe\u7f6espringdoc.swagger-ui.enabled\u4e3afalse");
        return new OpenAPI().info(info);
    }
}

