/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.error;

import brave.Tracer;
import com.cntaiping.fsc.core.exception.TpcloudException;
import com.cntaiping.fsc.core.model.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

public class GlobalHttpExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalHttpExceptionHandler.class);
    @Autowired
    private Tracer tracer;

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        StringBuilder sb = new StringBuilder();
        for (FieldError error : ex.getBindingResult().getFieldErrors()) {
            sb.append(error.getField() + ": " + error.getDefaultMessage());
            sb.append("\n");
        }
        for (FieldError error : ex.getBindingResult().getGlobalErrors()) {
            sb.append(error.getObjectName() + ": " + error.getDefaultMessage());
            sb.append("\n");
        }
        BaseResponse result = new BaseResponse("0001", sb.toString(), null);
        return this.createResponseEntity(status, (BaseResponse<Object>)result, new HttpHeaders());
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        String msg = ex.getParameterName() + " parameter is missing";
        BaseResponse result = new BaseResponse("0001", msg, null);
        return this.createResponseEntity(status, (BaseResponse<Object>)result, new HttpHeaders());
    }

    protected ResponseEntity<Object> handleNoHandlerFoundException(NoHandlerFoundException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        String msg = "No handler found for " + ex.getHttpMethod() + " " + ex.getRequestURL();
        BaseResponse result = new BaseResponse("0001", msg, null);
        return this.createResponseEntity(status, (BaseResponse<Object>)result, new HttpHeaders());
    }

    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(ex.getMethod());
        sb.append(" method is not supported for this request. Supported methods are ");
        ex.getSupportedHttpMethods().forEach(t -> sb.append(t + " "));
        BaseResponse result = new BaseResponse("0001", sb.toString(), null);
        HttpHeaders header = new HttpHeaders();
        header.add("Content-Type", "application/json");
        return this.createResponseEntity(status, (BaseResponse<Object>)result, header);
    }

    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(ex.getContentType());
        sb.append(" media type is not supported. Supported media types are ");
        ex.getSupportedMediaTypes().forEach(t -> sb.append(t + ", "));
        String msg = sb.substring(0, sb.length() - 2);
        BaseResponse result = new BaseResponse("0001", msg, null);
        HttpHeaders header = new HttpHeaders();
        return this.createResponseEntity(status, (BaseResponse<Object>)result, header);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        ProblemDetail body = this.createProblemDetail((Exception)ex, status, "Failed to read request", null, null, request);
        HttpHeaders header = new HttpHeaders();
        BaseResponse result = new BaseResponse("0001", body.toString(), null);
        return this.createResponseEntity(status, (BaseResponse<Object>)result, header);
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public ResponseEntity<Object> handleDuplicateKey(DuplicateKeyException ex, WebRequest request) {
        logger.error(ex.getLocalizedMessage(), (Throwable)ex);
        HttpStatus status = HttpStatus.BAD_REQUEST;
        BaseResponse result = new BaseResponse("0014", "Data already exists.", null);
        return this.createResponseEntity((HttpStatusCode)status, (BaseResponse<Object>)result, new HttpHeaders());
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleAll(Exception ex, WebRequest request) {
        logger.error(ex.getLocalizedMessage(), (Throwable)ex);
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        BaseResponse result = new BaseResponse("0017", status.getReasonPhrase(), null);
        return this.createResponseEntity((HttpStatusCode)status, (BaseResponse<Object>)result, new HttpHeaders());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException ex, WebRequest request) {
        String msg = ex.getName() + " should be of type " + ex.getRequiredType().getName();
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        BaseResponse result = new BaseResponse("0001", msg, null);
        return this.createResponseEntity((HttpStatusCode)status, (BaseResponse<Object>)result, new HttpHeaders());
    }

    @ExceptionHandler(value={TpcloudException.class})
    public ResponseEntity<Object> handleAll(TpcloudException ex, WebRequest request) {
        logger.error(ex.getLocalizedMessage(), (Throwable)ex);
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        BaseResponse result = new BaseResponse(ex.getResCode(), ex.getLocalizedMessage(), null);
        return this.createResponseEntity((HttpStatusCode)status, (BaseResponse<Object>)result, new HttpHeaders());
    }

    private ResponseEntity<Object> createResponseEntity(HttpStatusCode status, BaseResponse<Object> result, HttpHeaders header) {
        header.addIfAbsent((Object)"Content-Type", (Object)"application/json");
        result.setTraceID(this.getTracerId());
        result.setSpanID(this.getSpanId());
        return new ResponseEntity(result, (MultiValueMap)header, status);
    }

    private String getSpanId() {
        return this.tracer != null ? this.tracer.currentSpan().context().spanIdString() : null;
    }

    private String getTracerId() {
        return this.tracer != null ? this.tracer.currentSpan().context().traceIdString() : null;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }
}

