/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.error;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cntaiping.fsc.core.exception.TpcloudException;
import com.cntaiping.fsc.core.model.BaseResponse;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class GlobalWebExceptionHandler
implements WebFilter,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalWebExceptionHandler.class);
    @Autowired
    private Tracer tracer;

    public GlobalWebExceptionHandler() {
        LOGGER.info("Init GlobalWebExceptionHandler");
    }

    public int getOrder() {
        return -99;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        String path = request.getPath().value();
        return chain.filter(exchange).onErrorResume(ex -> Mono.deferContextual(contextView -> {
            try (ContextSnapshot.Scope scope = ContextSnapshot.setThreadLocalsFrom((Object)contextView, (String[])new String[]{"micrometer.observation"});){
                Mono mono;
                String message;
                HttpStatus status;
                String resultCode;
                WebExchangeBindException e;
                String data = null;
                Optional<Object> headers = Optional.empty();
                if (ex instanceof WebExchangeBindException) {
                    e = (WebExchangeBindException)ex;
                    resultCode = "0001";
                    status = HttpStatus.BAD_REQUEST;
                    StringBuilder sb = new StringBuilder();
                    List errors = e.getBindingResult().getAllErrors();
                    for (ObjectError error : errors) {
                        if (error instanceof FieldError) {
                            FieldError fieldError = (FieldError)error;
                            sb.append(fieldError.getField()).append(" - ").append(fieldError.getDefaultMessage()).append("\r\n");
                            continue;
                        }
                        sb.append(error.getDefaultMessage());
                    }
                    message = sb.toString();
                    LOGGER.info("Validation failed: {}, path :{},", (Object)path, (Object)message);
                } else if (ex instanceof TpcloudException) {
                    TpcloudException e2 = (TpcloudException)ex;
                    resultCode = e2.getResCode();
                    message = e2.getLocalizedMessage();
                    status = HttpStatus.INTERNAL_SERVER_ERROR;
                    data = ex.getLocalizedMessage();
                    LOGGER.warn("business exception, path :{}, resultCode: {}, reason: {}", new Object[]{path, resultCode, message});
                } else if (ex instanceof ResponseStatusException) {
                    ResponseStatusException e3 = (ResponseStatusException)ex;
                    resultCode = "0017";
                    status = Optional.of(e3.getStatusCode()).map(HttpStatusCode::value).map(HttpStatus::resolve).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
                    message = e3.getLocalizedMessage();
                    headers = Optional.of(e3.getHeaders());
                    LOGGER.warn("response exception, path :{}, status: {}, reason: {}", new Object[]{path, status.value(), message});
                } else {
                    message = HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
                    resultCode = "0017";
                    status = HttpStatus.INTERNAL_SERVER_ERROR;
                    LOGGER.error(ex.getLocalizedMessage(), ex);
                }
                if (exchange.getResponse().isCommitted()) {
                    e = Mono.empty();
                    return e;
                }
                ServerHttpResponse response = exchange.getResponse();
                response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
                response.getHeaders().addAll((MultiValueMap)headers.orElse(HttpHeaders.EMPTY));
                response.setStatusCode((HttpStatusCode)status);
                Span span = this.tracer.currentSpan();
                BaseResponse baseResp = new BaseResponse(resultCode, message, (Object)data);
                if (span != null) {
                    TraceContext context = span.context();
                    String traceID = context.traceId();
                    String spanId = context.spanId();
                    baseResp.setTraceID(traceID);
                    baseResp.setSpanID(spanId);
                }
                try {
                    DataBuffer dataBuffer = response.bufferFactory().wrap(JSON.toJSONBytes((Object)baseResp, (SerializerFeature[])new SerializerFeature[0]));
                    mono = response.writeWith((Publisher)Mono.just((Object)dataBuffer));
                    return mono;
                }
                catch (Exception e4) {
                    block20: {
                        LOGGER.warn(e4.getMessage());
                        mono = response.writeWith((Publisher)Mono.empty());
                        if (scope == null) break block20;
                        scope.close();
                    }
                    return mono;
                }
            }
        }));
    }
}

