/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.listener;

import com.cntaiping.fsc.common.base.BaseApiResource;
import com.cntaiping.fsc.common.config.CommonProperties;
import com.cntaiping.fsc.core.annotation.TpResourceMapping;
import com.cntaiping.fsc.core.exception.TpcloudException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;

public class ApiResourceRegisterListener
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate<String, Object> redisTemplate;
    private CommonProperties commonProperties;

    public ApiResourceRegisterListener(RedisTemplate<String, Object> redistTemplate) {
        this.redisTemplate = redistTemplate;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext cxt = event.getApplicationContext();
        this.commonProperties = (CommonProperties)cxt.getBean(CommonProperties.class);
        this.parseApiResource(cxt.getBeansWithAnnotation(Controller.class));
    }

    private void parseApiResource(Map<String, Object> beans) {
        HashMap<String, BaseApiResource> resourceMap = null;
        if (beans == null || beans.isEmpty()) {
            this.LOG.error("Init Api Resource fail! No Bean was annotated by Controller!");
        } else {
            resourceMap = new HashMap<String, BaseApiResource>();
            BaseApiResource app = new BaseApiResource();
            app.setId(this.commonProperties.getResourceRootId() == null ? this.commonProperties.getApplicationName() : this.commonProperties.getResourceRootId());
            app.setName(this.commonProperties.getResourceRootName());
            app.setAppName(this.commonProperties.getApplicationName());
            String appUrl = this.commonProperties.getUrlPrefixOnGateway();
            app.setUrl(appUrl + "/**");
            app.setResType((short)0);
            app.setIsLeaf((short)1);
            app.setIsExpanded((short)1);
            app.setNodeLevel(0);
            app.setValid((short)1);
            app.setStatus((short)0);
            app.setHidden((short)0);
            app.setVersion(0);
            resourceMap.put(app.getId(), app);
            if (StringUtils.isBlank((CharSequence)app.getUrl())) {
                this.LOG.warn("Init Api Resource fail! app.common.UrlPrefixOnGateway can not be null!");
            } else {
                for (Map.Entry<String, Object> bean : beans.entrySet()) {
                    Method[] methods;
                    Class<?> clazz = bean.getValue().getClass();
                    TpResourceMapping mapping = null;
                    if (clazz.isAnnotationPresent(TpResourceMapping.class)) {
                        mapping = clazz.getAnnotation(TpResourceMapping.class);
                    } else {
                        Class<?>[] interfaceClazzs;
                        for (Class<?> iClazz : interfaceClazzs = clazz.getInterfaces()) {
                            if (!iClazz.isAnnotationPresent(TpResourceMapping.class)) continue;
                            mapping = iClazz.getAnnotation(TpResourceMapping.class);
                            clazz = iClazz;
                            break;
                        }
                    }
                    if (mapping == null) {
                        this.LOG.warn("Skip Api Resource Parsing! No TpResourceMapping Annotation on controller interface. ResPath: {}", (Object)bean.getValue().getClass().getName());
                        continue;
                    }
                    this.checkTpResourceMapping(mapping, bean.getValue().getClass().getName());
                    BaseApiResource controller = new BaseApiResource();
                    controller.setId((String)(mapping.resourceId().length() == 2 ? app.getId() + mapping.resourceId() : mapping.resourceId()));
                    controller.setName(mapping.resourceName());
                    controller.setpId(app.getId());
                    controller.setResType((short)0);
                    String controllerUrl = null;
                    if (mapping.value().length > 0) {
                        controllerUrl = appUrl + mapping.value()[0];
                        controller.setUrl(controllerUrl + "/**");
                    }
                    controller.setResPath(bean.getValue().getClass().getName());
                    controller.setAppName(this.commonProperties.getApplicationName());
                    controller.setIsLeaf((short)1);
                    controller.setIsExpanded((short)0);
                    controller.setNodeLevel(1);
                    controller.setValid((short)1);
                    controller.setStatus((short)0);
                    controller.setHidden((short)0);
                    controller.setVersion(0);
                    if (!StringUtils.isNotBlank((CharSequence)controller.getUrl())) {
                        throw new TpcloudException(String.format("Init Api Resource fail! Url value of TpResourceMapping can not be null! Controller path: %s", controller.getResPath()));
                    }
                    this.LOG.debug("Init Api Resource. Controller name: {}, id: {}, url: {}, class path: {}", new Object[]{controller.getName(), controller.getId(), controller.getUrl(), controller.getResPath()});
                    if (resourceMap.containsKey(controller.getId())) {
                        resourceMap.clear();
                        resourceMap = null;
                        throw new TpcloudException(String.format("\u521d\u59cb\u5316API\u8d44\u6e90\u65f6\u51fa\u9519\uff0c\u5b58\u5728\u91cd\u590d\u7684\u8d44\u6e90\u7f16\u7801(resourceId: %s), \u8d44\u6e90\u8def\u5f84\uff1a%s", controller.getId(), controller.getResPath()));
                    }
                    resourceMap.put(controller.getId(), controller);
                    BaseApiResource resource = null;
                    for (Method m : methods = clazz.getMethods()) {
                        if (!m.isAnnotationPresent(TpResourceMapping.class)) continue;
                        TpResourceMapping rm = m.getAnnotation(TpResourceMapping.class);
                        this.checkTpResourceMapping(rm, controller.getResPath() + "." + m.getName());
                        resource = new BaseApiResource();
                        resource.setId((String)(rm.resourceId().length() == 2 ? controller.getId() + rm.resourceId() : rm.resourceId()));
                        resource.setpId(controller.getId());
                        if (rm.value().length > 0) {
                            resource.setUrl(controllerUrl + rm.value()[0]);
                        }
                        resource.setResType((short)0);
                        resource.setName(rm.resourceName());
                        resource.setDescription(rm.description());
                        resource.setResPath(controller.getResPath() + "." + m.getName());
                        resource.setAppName(this.commonProperties.getApplicationName());
                        resource.setIsLeaf((short)0);
                        resource.setIsExpanded((short)0);
                        resource.setNodeLevel(2);
                        resource.setStatus((short)0);
                        resource.setValid((short)1);
                        resource.setVersion(0);
                        resource.setHidden(rm.hidden() ? (short)1 : 0);
                        if (!StringUtils.isNotBlank((CharSequence)resource.getUrl())) {
                            throw new TpcloudException(String.format("Init Api Resource fail! Value of TpResourceMapping can not be null! Method path: %s", resource.getResPath()));
                        }
                        this.LOG.debug("Init Api Resource. Method name: {}, id: {}, url: {}, hidden: {}", new Object[]{resource.getName(), resource.getId(), resource.getUrl(), rm.hidden()});
                        if (!resourceMap.containsKey(resource.getId())) {
                            resourceMap.put(resource.getId(), resource);
                            continue;
                        }
                        resourceMap.clear();
                        resourceMap = null;
                        throw new TpcloudException(String.format("\u521d\u59cb\u5316API\u8d44\u6e90\u65f6\u51fa\u9519\uff0c\u5b58\u5728\u91cd\u590d\u7684\u8d44\u6e90\u7f16\u7801(resourceId: %s), \u8d44\u6e90\u8def\u5f84\uff1a%s", resource.getId(), resource.getResPath()));
                    }
                }
            }
            if (this.commonProperties.isEnableApiResourceRegister() && this.redisTemplate != null && resourceMap != null && !resourceMap.isEmpty()) {
                this.LOG.debug("Updete Api Resource List To Redis.");
                this.redisTemplate.opsForHash().putAll((Object)"tp_api_resource_hash", resourceMap);
            }
        }
    }

    private boolean checkTpResourceMapping(TpResourceMapping mapping, String resPath) {
        if (mapping == null) {
            this.LOG.error("No TpResourceMapping Annotation on controller interface or Method. ResPath: {}", (Object)resPath);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)mapping.resourceId())) {
            throw new TpcloudException("Parse TpResourceMapping Annotation fail! ResourceId can not be blank. ResPath: " + resPath);
        }
        if (StringUtils.isBlank((CharSequence)mapping.resourceName())) {
            throw new TpcloudException("Parse TpResourceMapping Annotation fail! ResourceName can not be blank. ResPath: " + resPath);
        }
        return true;
    }
}

