/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import com.alibaba.fastjson.JSON;
import com.cntaiping.fsc.common.constant.BusinessNoFieldType;
import com.cntaiping.fsc.common.util.HttpClientUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class BusinessNoUtil {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate<String, Object> redisTemplate;
    private HttpClientUtil httpClientUtil;
    private String systemApiUrl;

    public BusinessNoUtil(RedisTemplate<String, Object> redisTemplate, HttpClientUtil httpClientUtil, String systemApiUrl) {
        Assert.notNull(redisTemplate, (String)"RedisTemplate can not be null when init BusinessNoUtil!");
        Assert.notNull((Object)httpClientUtil, (String)"HttpClientUtil can not be null when init BusinessNoUtil!");
        this.redisTemplate = redisTemplate;
        this.httpClientUtil = httpClientUtil;
        this.systemApiUrl = systemApiUrl;
        if (systemApiUrl == null || systemApiUrl.length() == 0) {
            this.LOG.warn("Init BusinessNoUtil failure! SystemApiUrl is not set in '*.yml'!");
        } else {
            this.LOG.debug("Init BusinessNoUtil finish.");
        }
    }

    public BusinessNoVo produceBusinessNo(BusinessNoReqVo businessNoReqVo) {
        Assert.notNull((Object)this.systemApiUrl, (String)"Invoke businessNoUtil.produceBusinessNo failure! SystemApiUrl is not set in '*.yml'!");
        String url = this.systemApiUrl + "business_no/produce";
        try {
            Object object = this.httpClientUtil.requestPost(url, JSON.toJSONString((Object)businessNoReqVo));
            BusinessNoVo businessNoResVo = new BusinessNoVo();
            businessNoResVo.setBusinessNo(PropertyUtils.getProperty((Object)object, (String)"businessNo").toString());
            businessNoResVo.setGroupNo(PropertyUtils.getProperty((Object)object, (String)"groupNo").toString());
            businessNoResVo.setMaxNo(Integer.parseInt(PropertyUtils.getProperty((Object)object, (String)"maxNo").toString()));
            return businessNoResVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void recordSequenceNoIfFailed(BusinessNoVo businessNoResVo) {
        Assert.notNull((Object)this.systemApiUrl, (String)"Invoke businessNoUtil.recordSequenceNoIfFailed failure! SystemApiUrl is not set in '*.yml'!");
        String url = this.systemApiUrl + "business_no/record_failed_no";
        try {
            this.httpClientUtil.requestPost(url, JSON.toJSONString((Object)businessNoResVo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteUsedBusinessNo(BusinessNoVo businessNoResVo) {
        Assert.notNull((Object)this.systemApiUrl, (String)"Invoke businessNoUtil.recordSequenceNoIfFailed failure! SystemApiUrl is not set in '*.yml'!");
        String url = this.systemApiUrl + "business_no/delete_used_no";
        try {
            this.httpClientUtil.requestPost(url, JSON.toJSONString((Object)businessNoResVo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void recordSequenceNosIfFailed(List<BusinessNoVo> businessNoResVos) {
        for (BusinessNoVo businessNoVo : businessNoResVos) {
            this.recordSequenceNoIfFailed(businessNoVo);
        }
    }

    public static class BusinessNoVo {
        private String businessNo;
        private String groupNo;
        private String sequenceNo;
        private int maxNo;

        public String getBusinessNo() {
            return this.businessNo;
        }

        public void setBusinessNo(String businessNo) {
            this.businessNo = businessNo;
        }

        public String getGroupNo() {
            return this.groupNo;
        }

        public void setGroupNo(String groupNo) {
            this.groupNo = groupNo;
        }

        public String getSequenceNo() {
            return this.sequenceNo;
        }

        public void setSequenceNo(String sequenceNo) {
            this.sequenceNo = sequenceNo;
        }

        public int getMaxNo() {
            return this.maxNo;
        }

        public void setMaxNo(int maxNo) {
            this.maxNo = maxNo;
        }
    }

    public static class BusinessNoConfigVo {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        private String fieldName;
        private String fieldValue;
        private int serialNo;
        private int length;
        private int cutStart;
        private int cutEnd;

        public BusinessNoConfigVo() {
        }

        public BusinessNoConfigVo(String fieldName, String fieldValue, int length, int cutStart, int cutEnd) {
            this.logger.info("The fieldType is " + fieldName);
            this.logger.info("The fieldValue is " + fieldValue);
            this.logger.info("The length is " + length);
            this.logger.info("The range of values is " + cutStart + " ~ " + cutEnd);
            this.fieldName = fieldName;
            Assert.isTrue((length >= 0 ? 1 : 0) != 0, (String)"length must be greater than 0!");
            Assert.isTrue((cutStart >= 0 ? 1 : 0) != 0, (String)"cutStart must be greater than 0!");
            Assert.isTrue((cutStart < cutEnd ? 1 : 0) != 0, (String)"cutStart must be less than cutEnd!");
            if (BusinessNoFieldType.YEAR.getFieldType().equals(fieldName)) {
                this.fieldValue = String.valueOf(Calendar.getInstance().get(1)).substring(cutStart, cutEnd);
            } else if (!BusinessNoFieldType.SEQUENCENO.getFieldType().equals(fieldName)) {
                Assert.notNull((Object)fieldValue, (String)("fieldValue of fieldName[" + fieldName + "] can not be null!"));
                Assert.isTrue((cutEnd <= fieldValue.length() ? 1 : 0) != 0, (String)"cutEnd can not be greater than fieldValue.length!");
                this.fieldValue = fieldValue.substring(cutStart, cutEnd);
            }
            this.cutStart = cutStart;
            this.cutEnd = cutEnd;
            this.length = length;
        }

        public int compareTo(BusinessNoConfigVo businessNoConfigVo) {
            return this.serialNo - businessNoConfigVo.getSerialNo();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        public int getSerialNo() {
            return this.serialNo;
        }

        public void setSerialNo(int serialNo) {
            this.serialNo = serialNo;
        }

        public int getCutStart() {
            return this.cutStart;
        }

        public void setCutStart(int cutStart) {
            this.cutStart = cutStart;
        }

        public int getCutEnd() {
            return this.cutEnd;
        }

        public void setCutEnd(int cutEnd) {
            this.cutEnd = cutEnd;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }
    }

    public static class BusinessNoReqVo {
        private String groupNo = "";
        private int currentSerialNo = 0;
        private String docType;
        private List<BusinessNoConfigVo> businessNoConfigVoList = new ArrayList<BusinessNoConfigVo>();

        public void addConfig(BusinessNoConfigVo businessNoConfigVo) {
            ++this.currentSerialNo;
            businessNoConfigVo.setSerialNo(this.currentSerialNo);
            this.businessNoConfigVoList.add(businessNoConfigVo);
            if (!BusinessNoFieldType.SEQUENCENO.getFieldType().equals(businessNoConfigVo.getFieldName()) && !BusinessNoFieldType.BUSINESSNO.getFieldType().equals(businessNoConfigVo.getFieldName())) {
                this.groupNo = this.groupNo + businessNoConfigVo.getFieldValue();
            }
        }

        public String getGroupNo() {
            return this.groupNo;
        }

        public void setGroupNo(String groupNo) {
            this.groupNo = groupNo;
        }

        public List<BusinessNoConfigVo> getBusinessNoConfigVoList() {
            return this.businessNoConfigVoList;
        }

        public void setBusinessNoConfigVoList(List<BusinessNoConfigVo> businessNoConfigVoList) {
            this.businessNoConfigVoList = businessNoConfigVoList;
        }

        public String getDocType() {
            return this.docType;
        }

        public void setDocType(String docType) {
            this.docType = docType;
        }
    }
}

