/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ClassUtil {
    public static boolean checkManifestClassPath(Class clazz) {
        boolean isValidate = true;
        Attributes attr = ClassUtil.getManifestAttrs(clazz);
        if (attr != null) {
            String value = attr.getValue("Class-Path");
            if (value == null) {
                System.out.println("Class-Path not exists in Manifess");
                return isValidate;
            }
            System.out.println("Class-Path:" + value);
            try {
                String currPath = ClassUtil.getJarContainingFolder(clazz);
                System.out.println("checking jar files exists in " + currPath);
                for (String dependency : value.split(" ")) {
                    String fileName = currPath + File.separator + dependency;
                    if (new File(fileName).isFile()) continue;
                    System.out.println("NOT FONUD!!!!:" + fileName);
                    isValidate = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isValidate;
    }

    public static Attributes getManifestAttrs(Class clazz) {
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            System.out.println("Class not in JAR file:" + classPath);
            return null;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            return manifest.getMainAttributes();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getJarContainingFolder(Class aclass) throws Exception {
        File jarFile;
        CodeSource codeSource = aclass.getProtectionDomain().getCodeSource();
        if (codeSource.getLocation() != null) {
            jarFile = new File(codeSource.getLocation().toURI());
        } else {
            String path = aclass.getResource(aclass.getSimpleName() + ".class").getPath();
            String jarFilePath = path.substring(path.indexOf(":") + 1, path.indexOf("!"));
            jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
            jarFile = new File(jarFilePath);
        }
        return jarFile.getParentFile().getAbsolutePath();
    }
}

