/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.drools.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.cntaiping.fsc.drools.model.RuleResult;
import com.cntaiping.fsc.drools.service.DroolsService;
import com.cntaiping.fsc.drools.service.PropertiesService;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.MapUtils;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.model.ServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DroolsServiceImpl
implements DroolsService {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PropertiesService propertiesService;
    @Autowired
    private RestTemplate restTemplate;
    protected static final String OBJECT_IDENTIFIER = "DEFAULT";

    private <T> RuleResult executeRule(String artifactId, String agendaGroup, String ksession, T insertObject, Map<String, Object> globalMap) {
        RuleResult<T> post = this.post(artifactId, agendaGroup, ksession, insertObject, globalMap);
        return post;
    }

    public <T> RuleResult executeRule(String artifactId, String agendaGroup, String ksession, T insertObject) {
        HashMap<String, Object> globalMap = new HashMap<String, Object>(4);
        globalMap.put("resultMap", new HashMap(16));
        globalMap.put("resultList", new ArrayList());
        return this.executeRule(artifactId, agendaGroup, ksession, insertObject, globalMap);
    }

    private <T> RuleResult executeRulesBatch(String artifactId, String agendaGroup, String ksession, List<T> list, Map<String, Object> globalMap) {
        RuleResult<T> post = this.postList(artifactId, agendaGroup, ksession, list, globalMap);
        return post;
    }

    @Override
    public <T> RuleResult executeRulesBatch(String artifactId, String agendaGroup, String ksession, List<T> list) {
        HashMap<String, Object> globalMap = new HashMap<String, Object>(4);
        globalMap.put("resultMap", new HashMap(16));
        globalMap.put("resultList", new ArrayList());
        return this.executeRulesBatch(artifactId, agendaGroup, ksession, list, globalMap);
    }

    private ServiceResponse<ExecutionResults> execute(String artifactId, String agendaGroup, String ksession, Object o, Map<String, Object> globalMap, Integer max) {
        return null;
    }

    private ServiceResponse<ExecutionResults> execute(String artifactId, String agendaGroup, String ksession, Map<String, Object> globalMap, Integer max, Object ... object) {
        return null;
    }

    private <T> RuleResult<T> post(String artifactId, String agendaGroup, String ksession, T object, Map<String, Object> globalMap) {
        String url = this.propertiesService.getKieServerUrl() + "/containers/instances/" + artifactId;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("lookup", ksession);
        ArrayList commands = new ArrayList();
        HashMap insert = new HashMap(2);
        HashMap<String, Object> insert1 = new HashMap<String, Object>(8);
        HashMap<String, T> insert2 = new HashMap<String, T>(2);
        insert2.put(object.getClass().getName(), object);
        insert1.put("object", insert2);
        insert1.put("out-identifier", OBJECT_IDENTIFIER);
        insert1.put("return-object", true);
        insert.put("insert", insert1);
        commands.add(insert);
        if (MapUtils.isNotEmpty(globalMap)) {
            for (Map.Entry<String, Object> map : globalMap.entrySet()) {
                HashMap global = new HashMap(2);
                HashMap<String, Object> global1 = new HashMap<String, Object>(8);
                HashMap<String, Object> global2 = new HashMap<String, Object>(2);
                global1.put("identifier", map.getKey());
                global1.put("out-identifier", map.getKey());
                Object value = map.getValue();
                global2.put(value.getClass().getName(), value);
                global1.put("object", global2);
                global.put("set-global", global1);
                commands.add(global);
            }
        }
        HashMap focus = new HashMap(2);
        HashMap<String, String> focus1 = new HashMap<String, String>(2);
        focus1.put("name", agendaGroup);
        focus.put("set-focus", focus1);
        commands.add(focus);
        HashMap fireAllRules = new HashMap(2);
        fireAllRules.put("fire-all-rules", new HashMap(2));
        commands.add(fireAllRules);
        params.put("commands", commands);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.getHeader());
        headers.add("Content-Type", "application/json");
        headers.add("X-KIE-ContentType", "JSON");
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        ResponseEntity postResult = this.restTemplate.postForEntity(url, (Object)new HttpEntity(params, (MultiValueMap)headers), JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)postResult.getBody();
        return this.conver(body, object, globalMap);
    }

    private <T> RuleResult<T> postList(String artifactId, String agendaGroup, String ksession, List<T> list, Map<String, Object> globalMap) {
        String url = this.propertiesService.getKieServerUrl() + "/containers/instances/" + artifactId;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("lookup", ksession);
        ArrayList commands = new ArrayList();
        HashMap insert = new HashMap(2);
        HashMap<String, Object> insert1 = new HashMap<String, Object>(8);
        HashMap insert2 = new HashMap(2);
        ArrayList insert3 = new ArrayList();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            HashMap<String, T> insert4 = new HashMap<String, T>(16);
            T t = list.get(i);
            insert4.put(t.getClass().getName(), t);
            insert3.add(insert4);
        }
        insert2.put("java.util.List", insert3);
        insert1.put("object", insert2);
        insert1.put("out-identifier", OBJECT_IDENTIFIER);
        insert1.put("return-object", true);
        insert.put("insert", insert1);
        commands.add(insert);
        if (MapUtils.isNotEmpty(globalMap)) {
            for (Map.Entry<String, Object> map : globalMap.entrySet()) {
                HashMap global = new HashMap(2);
                HashMap<String, Object> global1 = new HashMap<String, Object>(8);
                HashMap<String, Object> global2 = new HashMap<String, Object>(2);
                global1.put("identifier", map.getKey());
                global1.put("out-identifier", map.getKey());
                Object value = map.getValue();
                global2.put(value.getClass().getName(), value);
                global1.put("object", global2);
                global.put("set-global", global1);
                commands.add(global);
            }
        }
        HashMap focus = new HashMap(2);
        HashMap<String, String> focus1 = new HashMap<String, String>(2);
        focus1.put("name", agendaGroup);
        focus.put("set-focus", focus1);
        commands.add(focus);
        HashMap fireAllRules = new HashMap(2);
        fireAllRules.put("fire-all-rules", new HashMap(2));
        commands.add(fireAllRules);
        params.put("commands", commands);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.getHeader());
        headers.add("Content-Type", "application/json");
        headers.add("X-KIE-ContentType", "JSON");
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        ResponseEntity postResult = this.restTemplate.postForEntity(url, (Object)new HttpEntity(params, (MultiValueMap)headers), JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)postResult.getBody();
        return this.converList(body, list, globalMap);
    }

    private <T> RuleResult<T> conver(JSONObject body, T t, Map<String, Object> globalMap) {
        this.LOG.debug("Drools service execution-results: {}", (Object)body.toJSONString());
        if (!"SUCCESS".equals(body.getString("type"))) {
            RuleResult ruleResult = new RuleResult();
            ruleResult.setResponseType(body.getString("type"));
            ruleResult.setResponseMsg(body.getString("msg"));
            return ruleResult;
        }
        RuleResult<Object> ruleResult = new RuleResult<Object>();
        ruleResult.setResponseType(body.getString("type"));
        ruleResult.setResponseMsg(body.getString("msg"));
        Class<?> aClass = t.getClass();
        Map executionResults = (Map)((Map)body.getObject("result", Map.class)).get("execution-results");
        List resultsList = null;
        if (executionResults != null && executionResults.containsKey("results")) {
            resultsList = (List)executionResults.get("results");
        }
        if (resultsList != null && resultsList.size() > 0) {
            HashMap resultMap = new HashMap(16);
            int len = resultsList.size();
            for (int i = 0; i < len; ++i) {
                Map resultObject = (Map)resultsList.get(i);
                String key = (String)resultObject.get("key");
                if (globalMap != null && globalMap.containsKey(key)) {
                    resultMap.put(key, resultObject.get("value"));
                }
                if (!OBJECT_IDENTIFIER.equals(key)) continue;
                Object vObject = ((Map)resultObject.get("value")).get(aClass.getName());
                Object value = TypeUtils.cast(vObject, aClass, (ParserConfig)ParserConfig.getGlobalInstance());
                ruleResult.setInsertObject(value);
            }
            ruleResult.setResultMap(resultMap);
        }
        return ruleResult;
    }

    private <T> RuleResult<T> converList(JSONObject body, List<T> list, Map<String, Object> globalMap) {
        if (!"SUCCESS".equals(body.getString("type"))) {
            RuleResult ruleResult = new RuleResult();
            ruleResult.setResponseType(body.getString("type"));
            ruleResult.setResponseMsg(body.getString("msg"));
            return ruleResult;
        }
        JSONArray resultsJSONArray = body.getJSONObject("result").getJSONObject("execution-results").getJSONArray("results");
        RuleResult ruleResult = new RuleResult();
        ruleResult.setResponseType(body.getString("type"));
        ruleResult.setResponseMsg(body.getString("msg"));
        T t = list.get(0);
        Class<?> aClass = t.getClass();
        if (resultsJSONArray != null && resultsJSONArray.size() > 0) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            int len = resultsJSONArray.size();
            for (int i = 0; i < len; ++i) {
                JSONObject jsonObject = resultsJSONArray.getJSONObject(i);
                String key = jsonObject.getString("key");
                if (globalMap != null && globalMap.containsKey(key)) {
                    resultMap.put(key, jsonObject.get((Object)"value"));
                }
                if (!OBJECT_IDENTIFIER.equals(key)) continue;
                ArrayList<Object> value = new ArrayList<Object>();
                JSONArray value1 = jsonObject.getJSONArray("value");
                if (value1 != null && value1.size() > 0) {
                    int lenj = value1.size();
                    for (int j = 0; j < lenj; ++j) {
                        JSONObject bean = value1.getJSONObject(j).getJSONObject(aClass.getName());
                        value.add(bean.toJavaObject(aClass));
                    }
                }
                ruleResult.setInsertList(value);
            }
            ruleResult.setResultMap(resultMap);
        }
        return ruleResult;
    }

    private String getHeader() {
        String auth = this.propertiesService.getKieServerUsername() + ":" + this.propertiesService.getKieServerPassword();
        byte[] bytes = new byte[]{};
        try {
            bytes = Base64.encodeBase64((byte[])auth.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuilder authHeader = new StringBuilder();
        authHeader.append("Basic ").append(new String(bytes));
        return authHeader.toString();
    }
}

