/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.drools.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassesUtil {
    public static void main(String[] args) throws URISyntaxException, ClassNotFoundException {
        long l = System.currentTimeMillis();
        Set<Class<?>> clazzs = ClassesUtil.getClasses("com.cntaiping.sg.tpsgi.drools.vo");
        long k = System.currentTimeMillis();
        System.out.println(k - l + "ms");
        for (Class<?> clazz : clazzs) {
            System.out.println(clazz.getName());
        }
    }

    public static Set<Class<?>> getClasses(String packageName) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageDirName = packageName.replace(".", File.separator);
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    System.err.println("file\u7c7b\u578b\u7684\u626b\u63cf");
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassesUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.startsWith(File.separator)) {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(File.separator);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace(File.separator, ".");
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Class.forName(packageName + "." + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassesUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + "." + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

