/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.rulesengine.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.rule.entity.ApisRuleRoute;
import com.jdaz.sinosoftgz.apis.commons.model.rule.mapper.ApisRuleRouteMapper;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleInfo;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleRouteRequest;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.ApisRuleRouteService;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.DslLoader;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.utils.DslScriptUtil;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.vo.RuleScript;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApisRuleRouteServiceImpl
extends ServiceImpl<ApisRuleRouteMapper, ApisRuleRoute>
implements ApisRuleRouteService {
    private DslLoader dslLoader;

    @Autowired
    public ApisRuleRouteServiceImpl(DslLoader dslLoader) {
        this.dslLoader = dslLoader;
    }

    @Override
    public List<RuleScript> routeAllScript(RuleRouteRequest ruleRouteRequest) {
        List<String> allRuleCodes = this.dslLoader.getAllRuleCode();
        List<String> routedRuleCodes = allRuleCodes.stream().filter(rc -> {
            Optional<RuleScript> ruleScriptOpt = this.dslLoader.getScript((String)rc);
            if (ruleScriptOpt.isPresent()) {
                RuleInfo ruleInfo = ruleScriptOpt.get().getRuleInfo();
                String ruleConditionKey = DslScriptUtil.conditionKey(ruleInfo.getRuleCondition());
                if (StringUtils.isEmpty((CharSequence)StringUtils.trimToEmpty((String)ruleConditionKey))) {
                    return true;
                }
                return DslScriptUtil.conditionKey(ruleRouteRequest).equals(ruleConditionKey);
            }
            return false;
        }).collect(Collectors.toList());
        return this.dslLoader.getScript(routedRuleCodes.toArray(new String[0]));
    }

    @Override
    public List<RuleScript> routeScript(RuleRouteRequest ruleRouteRequest) {
        return null;
    }
}

