/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.rulesengine.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.configs.DslLoaderProperties;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleInfo;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.AbstractDslLoader;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.utils.DslScriptUtil;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.vo.RuleScript;
import groovy.lang.Script;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathDslLoader
extends AbstractDslLoader {
    private static final Logger log = LoggerFactory.getLogger(ClasspathDslLoader.class);
    static final String CLASSPATH_PATH_SEPARATOR = "/";

    public ClasspathDslLoader(DslLoaderProperties loaderProperties) {
        super(loaderProperties);
    }

    @Override
    public Map<String, RuleScript> reloadAll() {
        try {
            LinkedHashMap<String, RuleScript> dslMap = new LinkedHashMap<String, RuleScript>();
            List<Object> fileNames = new ArrayList();
            String path = this.loaderProperties.getPath();
            URL resourceUrl = ClasspathDslLoader.class.getResource(path);
            File resourceDir = null;
            if (resourceUrl != null) {
                resourceDir = new File(resourceUrl.getFile());
            }
            fileNames = resourceDir == null || !resourceDir.exists() ? FileUtil.listFileNames((String)path) : Arrays.asList(resourceDir.listFiles()).stream().map(File::getName).collect(Collectors.toList());
            for (String fileName : fileNames) {
                RuleScript ruleScript = this.load(String.join((CharSequence)CLASSPATH_PATH_SEPARATOR, path, fileName));
                if (ruleScript == null) continue;
                dslMap.put(ruleScript.getRuleCode(), ruleScript);
            }
            LinkedHashMap<String, RuleScript> linkedHashMap = dslMap;
            return linkedHashMap;
        }
        finally {
            DslScriptUtil.afterParse();
        }
    }

    @Override
    public RuleScript load(String filePath) {
        RuleScript ruleScript = null;
        long startTime = System.currentTimeMillis();
        log.debug("DSL\uff1a{}\u5f00\u59cb\u52a0\u8f7d", (Object)filePath);
        InputStream resourceAsStream = ClasspathDslLoader.class.getResourceAsStream(filePath);
        if (resourceAsStream == null) {
            resourceAsStream = FileUtil.getInputStream((String)filePath);
        }
        long dslStrReadStartTime = System.currentTimeMillis();
        String dslStr = IoUtil.read((InputStream)resourceAsStream, (String)"utf-8");
        log.debug("DSL\uff1a{}\u811a\u672c\u6587\u4ef6\u8bfb\u53d6IO\u8017\u65f6{}ms", (Object)filePath, (Object)(System.currentTimeMillis() - dslStrReadStartTime));
        long dslParseStartTime = System.currentTimeMillis();
        Script script = DslScriptUtil.parseDsl(dslStr);
        log.debug("DSL\uff1a{}\u811a\u672c\u6587\u4ef6\u89e3\u6790\u8017\u65f6{}ms", (Object)filePath, (Object)(System.currentTimeMillis() - dslParseStartTime));
        if (script != null) {
            long dslInvokeStartTime = System.currentTimeMillis();
            RuleInfo ruleInfo = DslScriptUtil.invokeGetRule(script, RuleInfo.class, null, new Object[0]);
            log.debug("DSL\uff1a{}RuleInfo\u83b7\u53d6\u65b9\u6cd5\u8c03\u7528\u8017\u65f6{}ms", (Object)filePath, (Object)(System.currentTimeMillis() - dslInvokeStartTime));
            if (ruleInfo != null) {
                ruleScript = RuleScript.builder().fileName(filePath).ruleInfo(ruleInfo).script(script).ruleCode(ruleInfo.getRuleCode()).build();
            }
        }
        log.debug("DSL\uff1a{}\u52a0\u8f7d\u5b8c\u6bd5,\u8017\u65f6{}ms", (Object)filePath, (Object)(System.currentTimeMillis() - startTime));
        return ruleScript;
    }

    public static ClasspathDslLoaderBuilder builder() {
        return new ClasspathDslLoaderBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClasspathDslLoader)) {
            return false;
        }
        ClasspathDslLoader other = (ClasspathDslLoader)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClasspathDslLoader;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "ClasspathDslLoader()";
    }

    public static class ClasspathDslLoaderBuilder {
        private DslLoaderProperties loaderProperties;

        ClasspathDslLoaderBuilder() {
        }

        public ClasspathDslLoaderBuilder loaderProperties(DslLoaderProperties loaderProperties) {
            this.loaderProperties = loaderProperties;
            return this;
        }

        public ClasspathDslLoader build() {
            return new ClasspathDslLoader(this.loaderProperties);
        }

        public String toString() {
            return "ClasspathDslLoader.ClasspathDslLoaderBuilder(loaderProperties=" + this.loaderProperties + ")";
        }
    }
}

