/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.rulesengine.service.impl;

import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleResult;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleRouteRequest;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.ApisRuleRouteService;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.RuleExecutorService;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.utils.DslScriptUtil;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.vo.RuleScript;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleExecutorServiceImpl
implements RuleExecutorService {
    @Autowired
    ApisRuleRouteService apisRuleRouteService;

    @Override
    public RuleResult executeVerify(StanderRequest standerRequest) {
        RuleRouteRequest ruleRouteRequest = new RuleRouteRequest();
        ruleRouteRequest.setRequest(standerRequest);
        ruleRouteRequest.setApiCode(standerRequest.getHeader().getBussinessType());
        List<RuleScript> scriptList = this.apisRuleRouteService.routeAllScript(ruleRouteRequest);
        Boolean result = true;
        RuleResult finalResult = new RuleResult();
        for (RuleScript s : scriptList) {
            RuleResult ruleResult = DslScriptUtil.invokeRuleExecute(s.getScript(), RuleResult.class, null, ruleRouteRequest);
            result = ruleResult.getResult() != false && result != false;
            finalResult.setMessage(ruleResult.getMessage());
        }
        finalResult.setResult(result);
        return finalResult;
    }
}

