/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.rulesengine.utils;

import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleCondition;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslScriptUtil {
    private static Logger log = LoggerFactory.getLogger(DslScriptUtil.class);
    public static final String RULE_METHOD_GET_RULE = "getRule";
    public static final String RULE_METHOD_RULE_CONDITION = "ruleCondition";
    public static final String RULE_METHOD_RULE_EXECUTE = "ruleExecute";
    private static ThreadLocal<GroovyShell> threadLocalShell = new ThreadLocal();

    public static Script parseDsl(String dslStr) {
        long startTime = System.currentTimeMillis();
        if (threadLocalShell.get() == null) {
            CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
            GroovyShell shell = new GroovyShell(Thread.currentThread().getContextClassLoader(), compilerConfiguration);
            threadLocalShell.set(shell);
        }
        log.warn("GroovyShell init time: {}", (Object)(System.currentTimeMillis() - startTime));
        long scriptStartTime = System.currentTimeMillis();
        Script script = threadLocalShell.get().parse(dslStr);
        log.warn("GroovyShell parse time: {}", (Object)(System.currentTimeMillis() - scriptStartTime));
        return script;
    }

    public static void afterParse() {
        threadLocalShell.remove();
        log.warn("\u56de\u6536ThreadLocal\u53d8\u91cf\u8d44\u6e90...");
    }

    public static <T> T invokeMethod(Script script, String method, Class<T> tClass, Map<String, Object> properties, Object ... args) {
        if (properties != null) {
            Binding binding = new Binding();
            properties.forEach((s, o) -> binding.setProperty(s, o));
            script.setBinding(binding);
        }
        Map methods = (Map)script.run();
        return tClass.cast(((Closure)methods.get(method)).call(args));
    }

    public static <T> T invokeGetRule(Script script, Class<T> tClass, Map<String, Object> properties, Object ... args) {
        return DslScriptUtil.invokeMethod(script, RULE_METHOD_GET_RULE, tClass, properties, args);
    }

    public static <T> T invokeRuleCondition(Script script, Class<T> tClass, Map<String, Object> properties, Object ... args) {
        return DslScriptUtil.invokeMethod(script, RULE_METHOD_RULE_CONDITION, tClass, properties, args);
    }

    public static <T> T invokeRuleExecute(Script script, Class<T> tClass, Map<String, Object> properties, Object ... args) {
        return DslScriptUtil.invokeMethod(script, RULE_METHOD_RULE_EXECUTE, tClass, properties, args);
    }

    public static String conditionKey(RuleCondition condition) {
        if (condition == null) {
            return "N/A";
        }
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)condition.getApiCode())) {
            params.add(StringUtils.trim((String)condition.getApiCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)condition.getChannelCode())) {
            params.add(StringUtils.trim((String)condition.getChannelCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)condition.getUserCode())) {
            params.add(StringUtils.trim((String)condition.getUserCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)condition.getProductCode())) {
            params.add(StringUtils.trim((String)condition.getProductCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)condition.getPlanCode())) {
            params.add(StringUtils.trim((String)condition.getPlanCode()));
        }
        return String.join((CharSequence)"_", params);
    }

    public static Boolean checkCondition(RuleCondition config, RuleCondition target) {
        Boolean finalResult = true;
        if (!StringUtils.isEmpty((CharSequence)config.getApiCode())) {
            finalResult = finalResult != false && StringUtils.trim((String)config.getApiCode()).equals(StringUtils.trim((String)target.getApiCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)config.getChannelCode())) {
            finalResult = finalResult != false && StringUtils.trim((String)config.getChannelCode()).equals(StringUtils.trim((String)target.getChannelCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)config.getUserCode())) {
            finalResult = finalResult != false && StringUtils.trim((String)config.getUserCode()).equals(StringUtils.trim((String)target.getUserCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)config.getProductCode())) {
            finalResult = finalResult != false && StringUtils.trim((String)config.getProductCode()).equals(StringUtils.trim((String)target.getProductCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)config.getPlanCode())) {
            finalResult = finalResult != false && StringUtils.trim((String)config.getPlanCode()).equals(StringUtils.trim((String)target.getPlanCode()));
        }
        return finalResult;
    }
}

