import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequestDTO
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleResult
import com.jdaz.sinosoftgz.apis.commons.rulesengine.vo.RuleResultType
import org.apache.commons.lang3.StringUtils

import static com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.RuleDsl.rule

rule {
    version 1
    ruleCode 'ApplicatEmailVerify'
    ruleName '投保人邮箱校验'
    desc '投保人邮箱校验，只要包含邮箱字段的都应执行此规则，个别渠道个性可在规则排除表配置排除'
    // 规则返回数据类型
    resultType RuleResultType.BOOLEAN
    // 规则触发路由，非必须，如不指定则默认触发或走规则路由表直接指定
    ruleCondition {
        apiCode "Insure"
    }
    // 规则执行脚本
    ruleExecute { StanderRequest req ->
        // 如果请求参数中包含了applicat.email则需校验
        def email = req.quotePriceServiceRequest.requestBody.quotePrice.appliClient[0].email;
        if(!StringUtils.isEmpty(email)) {
            // 投保人邮箱校验，采用GeneralRegxs标准正则表达式中的Email正则进行校验
            return new RuleResult(result: (email =~ GeneralRegxs.Email).matches())
        } else {
            return new RuleResult(result: true)
        }
    }
    // 本地测试脚本，写在这个里面
    testScript { rule ->
        def parmas = StanderRequest.builder()
                .header(null)
                .quotePriceServiceRequest(QuotePriceServiceRequest.builder()
                        .requestHead(null)
                        .requestBody(QuotePriceServiceRequestDTO.builder()
                                .quotePrice(QuotePriceDTO.builder()
                                        .appliClient(new ArrayList<AppliClientDTO>(){{
                                            add(AppliClientDTO.builder()
                                                    .email("test@qq.com")
                                                    .build())
                                        }})
                                        .build())
                                .build())
                        .build())
                .build()
        // 测试合法邮箱校验
        def ruleResult1 = rule.ruleExecute(parmas)
        assert ruleResult1.result == true : "正确的邮箱地址应该返回true"
        // 测试非法邮箱校验
        def parmas2 = StanderRequest.builder()
                .header(null)
                .quotePriceServiceRequest(QuotePriceServiceRequest.builder()
                        .requestHead(null)
                        .requestBody(QuotePriceServiceRequestDTO.builder()
                                .quotePrice(QuotePriceDTO.builder()
                                        .appliClient(new ArrayList<AppliClientDTO>(){{
                                            add(AppliClientDTO.builder()
                                                    .email("testqq.com")
                                                    .build())
                                        }})
                                        .build())
                                .build())
                        .build())
                .build()
        def ruleResult2 = rule.ruleExecute(parmas2)
        assert ruleResult2.result == false : "不正确的邮箱地址应该返回false"
        println("处理后的错误消息 -> ${ruleResult2.message}")
    }
}
//// 测试，放开下面的注释，运行dsl文件：
        .runTest()



