/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.tenant.core.db;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.toolkit.SqlParserUtils;
import com.lenovo.cloud.framework.tenant.config.TenantProperties;
import com.lenovo.cloud.framework.tenant.core.context.TenantContextHolder;
import java.util.HashSet;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;

public class TenantDatabaseInterceptor
implements TenantLineHandler {
    private final Set<String> ignoreTables = new HashSet<String>();

    public TenantDatabaseInterceptor(TenantProperties tenantProperties) {
        tenantProperties.getIgnoreTables().forEach(string -> {
            this.ignoreTables.add(string.toLowerCase());
            this.ignoreTables.add(string.toUpperCase());
        });
        this.ignoreTables.add("DUAL");
    }

    public Expression getTenantId() {
        return new LongValue(TenantContextHolder.getRequiredTenantId().longValue());
    }

    public boolean ignoreTable(String string) {
        return TenantContextHolder.isIgnore() || CollUtil.contains(this.ignoreTables, (Object)SqlParserUtils.removeWrapperSymbol((String)string));
    }
}

