/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.tenant.core.mq.redis;

import cn.hutool.core.util.StrUtil;
import com.lenovo.cloud.framework.mq.redis.core.interceptor.RedisMessageInterceptor;
import com.lenovo.cloud.framework.mq.redis.core.message.AbstractRedisMessage;
import com.lenovo.cloud.framework.tenant.core.context.TenantContextHolder;

public class TenantRedisMessageInterceptor
implements RedisMessageInterceptor {
    public void sendMessageBefore(AbstractRedisMessage abstractRedisMessage) {
        Long l = TenantContextHolder.getTenantId();
        if (l != null) {
            abstractRedisMessage.addHeader("tenant-id", l.toString());
        }
    }

    public void consumeMessageBefore(AbstractRedisMessage abstractRedisMessage) {
        String string = abstractRedisMessage.getHeader("tenant-id");
        if (StrUtil.isNotEmpty((CharSequence)string)) {
            TenantContextHolder.setTenantId(Long.valueOf(string));
        }
    }

    public void consumeMessageAfter(AbstractRedisMessage abstractRedisMessage) {
        TenantContextHolder.clear();
    }
}

