/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.tenant.core.service;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.lenovo.cloud.framework.common.pojo.CommonResult;
import com.lenovo.cloud.framework.common.util.cache.CacheUtils;
import com.lenovo.cloud.framework.tenant.core.service.TenantFrameworkService;
import com.lenovo.cloud.module.system.api.tenant.TenantApi;
import java.time.Duration;
import java.util.List;
import lombok.Generated;

public class TenantFrameworkServiceImpl
implements TenantFrameworkService {
    private final TenantApi tenantApi;
    private final LoadingCache<Object, List<Long>> getTenantIdsCache = CacheUtils.buildAsyncReloadingCache((Duration)Duration.ofMinutes(1L), (CacheLoader)new CacheLoader<Object, List<Long>>(){

        public List<Long> load(Object object) {
            return (List)TenantFrameworkServiceImpl.this.tenantApi.getTenantIdList().getCheckedData();
        }
    });
    private final LoadingCache<Long, CommonResult<Boolean>> validTenantCache = CacheUtils.buildAsyncReloadingCache((Duration)Duration.ofMinutes(1L), (CacheLoader)new CacheLoader<Long, CommonResult<Boolean>>(){

        public CommonResult<Boolean> load(Long l) {
            return TenantFrameworkServiceImpl.this.tenantApi.validTenant(l);
        }
    });

    @Override
    public List<Long> getTenantIds() {
        return (List)this.getTenantIdsCache.get((Object)Boolean.TRUE);
    }

    @Override
    public void validTenant(Long l) {
        ((CommonResult)this.validTenantCache.get((Object)l)).checkError();
    }

    @Generated
    public TenantFrameworkServiceImpl(TenantApi tenantApi) {
        this.tenantApi = tenantApi;
    }
}

