/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import com.lenovo.cloud.framework.tenant.core.util.TenantUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedMethod;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.ObjectUtils;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object object, Method method) {
        super(object, method);
    }

    public InvocableHandlerMethod(Object object, String string, Class<?> ... classArray) throws NoSuchMethodException {
        super(object, string, (Class[])classArray);
    }

    public void setMessageMethodArgumentResolvers(HandlerMethodArgumentResolverComposite handlerMethodArgumentResolverComposite) {
        this.resolvers = handlerMethodArgumentResolverComposite;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    @Nullable
    public Object invoke(Message<?> message, Object ... objectArray) throws Exception {
        Long l;
        Object[] objectArray2 = this.getMethodArgumentValues(message, objectArray);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Arguments: " + Arrays.toString(objectArray2)));
        }
        if ((l = this.parseTenantId(message)) == null) {
            return this.doInvoke(objectArray2);
        }
        return TenantUtils.execute(l, () -> this.doInvoke(objectArray2));
    }

    private Long parseTenantId(Message<?> message) {
        Object object = message.getHeaders().get((Object)"tenant-id");
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        if (object instanceof byte[]) {
            return Long.parseLong(new String((byte[])object));
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b\uff1a" + object);
    }

    protected Object[] getMethodArgumentValues(Message<?> message, Object ... objectArray) throws Exception {
        Object[] objectArray2 = this.getMethodParameters();
        if (ObjectUtils.isEmpty((Object[])objectArray2)) {
            return EMPTY_ARGS;
        }
        Object[] objectArray3 = new Object[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray2[i];
            object.initParameterNameDiscovery(this.parameterNameDiscoverer);
            objectArray3[i] = InvocableHandlerMethod.findProvidedArgument((MethodParameter)object, (Object[])objectArray);
            if (objectArray3[i] != null) continue;
            if (!this.resolvers.supportsParameter((MethodParameter)object)) {
                throw new MethodArgumentResolutionException(message, (MethodParameter)object, InvocableHandlerMethod.formatArgumentError((MethodParameter)object, (String)"No suitable resolver"));
            }
            try {
                objectArray3[i] = this.resolvers.resolveArgument((MethodParameter)object, message);
                continue;
            }
            catch (Exception exception) {
                String string;
                if (this.logger.isDebugEnabled() && (string = exception.getMessage()) != null && !string.contains(object.getExecutable().toGenericString())) {
                    this.logger.debug((Object)InvocableHandlerMethod.formatArgumentError((MethodParameter)object, (String)string));
                }
                throw exception;
            }
        }
        return objectArray3;
    }

    @Nullable
    protected Object doInvoke(Object ... objectArray) throws Exception {
        try {
            return this.getBridgedMethod().invoke(this.getBean(), objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assertTargetBean(this.getBridgedMethod(), this.getBean(), objectArray);
            String string = illegalArgumentException.getMessage() == null || illegalArgumentException.getCause() instanceof NullPointerException ? "Illegal argument" : illegalArgumentException.getMessage();
            throw new IllegalStateException(this.formatInvokeError(string, objectArray), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            if (throwable instanceof Error) {
                Error error = (Error)throwable;
                throw error;
            }
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                throw exception;
            }
            throw new IllegalStateException(this.formatInvokeError("Invocation failure", objectArray), throwable);
        }
    }

    MethodParameter getAsyncReturnValueType(@Nullable Object object) {
        return new AsyncResultMethodParameter(object);
    }

    private class AsyncResultMethodParameter
    extends AnnotatedMethod.AnnotatedMethodParameter {
        @Nullable
        private final Object returnValue;
        private final ResolvableType returnType;

        public AsyncResultMethodParameter(Object object) {
            super((AnnotatedMethod)InvocableHandlerMethod.this, -1);
            this.returnValue = object;
            this.returnType = ResolvableType.forType((Type)super.getGenericParameterType()).getGeneric(new int[0]);
        }

        protected AsyncResultMethodParameter(AsyncResultMethodParameter asyncResultMethodParameter) {
            super((AnnotatedMethod)InvocableHandlerMethod.this, (AnnotatedMethod.AnnotatedMethodParameter)asyncResultMethodParameter);
            this.returnValue = asyncResultMethodParameter.returnValue;
            this.returnType = asyncResultMethodParameter.returnType;
        }

        public Class<?> getParameterType() {
            if (this.returnValue != null) {
                return this.returnValue.getClass();
            }
            if (!ResolvableType.NONE.equals((Object)this.returnType)) {
                return this.returnType.toClass();
            }
            return super.getParameterType();
        }

        public Type getGenericParameterType() {
            return this.returnType.getType();
        }

        public AsyncResultMethodParameter clone() {
            return new AsyncResultMethodParameter(this);
        }
    }
}

