/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.config;

import com.lenovo.cloud.framework.custom.security.config.properties.CorsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={CorsProperties.class})
@ConditionalOnProperty(prefix="lenovo.security.cors", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class CustomCorsConfiguration {
    private final CorsProperties properties;

    public CustomCorsConfiguration(CorsProperties corsProperties) {
        this.properties = corsProperties;
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource urlBasedCorsConfigurationSource = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        this.properties.getAllowedOrigins().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedOrigin(arg_0));
        this.properties.getAllowedMethods().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedMethod(arg_0));
        this.properties.getAllowedHeaders().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedHeader(arg_0));
        corsConfiguration.setAllowCredentials(Boolean.valueOf(this.properties.isAllowCredentials()));
        corsConfiguration.setMaxAge(Long.valueOf(this.properties.getMaxAge()));
        this.properties.getExposedHeaders().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addExposedHeader(arg_0));
        urlBasedCorsConfigurationSource.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsFilter((CorsConfigurationSource)urlBasedCorsConfigurationSource);
    }
}

