/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.config;

import com.lenovo.cloud.framework.custom.security.config.properties.SecurityHeadersProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@EnableConfigurationProperties(value={SecurityHeadersProperties.class})
@ConditionalOnProperty(prefix="lenovo.security.headers", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class SecurityHeadersConfiguration {
    private final SecurityHeadersProperties properties;
    private final AntPathMatcher pathMatcher;

    public SecurityHeadersConfiguration(SecurityHeadersProperties securityHeadersProperties) {
        this.properties = securityHeadersProperties;
        this.pathMatcher = new AntPathMatcher();
    }

    @Bean
    public OncePerRequestFilter securityHeadersFilter() {
        return new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
                if (!SecurityHeadersConfiguration.this.properties.isEnabled()) {
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                String string = httpServletRequest.getRequestURI();
                List<String> list = SecurityHeadersConfiguration.this.properties.getExcludeUrls();
                if (list != null && list.stream().anyMatch(string2 -> SecurityHeadersConfiguration.this.pathMatcher.match(string2, string))) {
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                httpServletResponse.setHeader("X-Frame-Options", SecurityHeadersConfiguration.this.properties.getXFrameOptions());
                httpServletResponse.setHeader("X-XSS-Protection", SecurityHeadersConfiguration.this.properties.getXXssProtection());
                httpServletResponse.setHeader("X-Content-Type-Options", SecurityHeadersConfiguration.this.properties.getXContentTypeOptions());
                httpServletResponse.setHeader("Strict-Transport-Security", SecurityHeadersConfiguration.this.properties.getStrictTransportSecurity());
                httpServletResponse.setHeader("Content-Security-Policy", SecurityHeadersConfiguration.this.properties.getContentSecurityPolicy());
                httpServletResponse.setHeader("Referrer-Policy", SecurityHeadersConfiguration.this.properties.getReferrerPolicy());
                httpServletResponse.setHeader("Permissions-Policy", SecurityHeadersConfiguration.this.properties.getPermissionsPolicy());
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        };
    }
}

