/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.config.properties;

import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="lenovo.security.cors")
public class CorsProperties {
    private boolean enabled = true;
    private List<String> allowedOrigins = List.of("*");
    private List<String> allowedMethods = List.of("GET", "POST", "PUT", "DELETE", "OPTIONS");
    private List<String> allowedHeaders = List.of("Authorization", "Content-Type", "X-Requested-With", "Accept", "Origin");
    private boolean allowCredentials = true;
    private long maxAge = 3600L;
    private List<String> exposedHeaders = List.of("Authorization", "Content-Type");

    @Generated
    public CorsProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @Generated
    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    @Generated
    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    @Generated
    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    @Generated
    public long getMaxAge() {
        return this.maxAge;
    }

    @Generated
    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    @Generated
    public CorsProperties setEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    @Generated
    public CorsProperties setAllowedOrigins(List<String> list) {
        this.allowedOrigins = list;
        return this;
    }

    @Generated
    public CorsProperties setAllowedMethods(List<String> list) {
        this.allowedMethods = list;
        return this;
    }

    @Generated
    public CorsProperties setAllowedHeaders(List<String> list) {
        this.allowedHeaders = list;
        return this;
    }

    @Generated
    public CorsProperties setAllowCredentials(boolean bl) {
        this.allowCredentials = bl;
        return this;
    }

    @Generated
    public CorsProperties setMaxAge(long l) {
        this.maxAge = l;
        return this;
    }

    @Generated
    public CorsProperties setExposedHeaders(List<String> list) {
        this.exposedHeaders = list;
        return this;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CorsProperties)) {
            return false;
        }
        CorsProperties corsProperties = (CorsProperties)object;
        if (!corsProperties.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != corsProperties.isEnabled()) {
            return false;
        }
        if (this.isAllowCredentials() != corsProperties.isAllowCredentials()) {
            return false;
        }
        if (this.getMaxAge() != corsProperties.getMaxAge()) {
            return false;
        }
        List<String> list = this.getAllowedOrigins();
        List<String> list2 = corsProperties.getAllowedOrigins();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<String> list3 = this.getAllowedMethods();
        List<String> list4 = corsProperties.getAllowedMethods();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        List<String> list5 = this.getAllowedHeaders();
        List<String> list6 = corsProperties.getAllowedHeaders();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        List<String> list7 = this.getExposedHeaders();
        List<String> list8 = corsProperties.getExposedHeaders();
        return !(list7 == null ? list8 != null : !((Object)list7).equals(list8));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof CorsProperties;
    }

    @Generated
    public int hashCode() {
        int n = 1;
        n = n * 59 + (this.isEnabled() ? 79 : 97);
        n = n * 59 + (this.isAllowCredentials() ? 79 : 97);
        long l = this.getMaxAge();
        n = n * 59 + (int)(l >>> 32 ^ l);
        List<String> list = this.getAllowedOrigins();
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<String> list2 = this.getAllowedMethods();
        n = n * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        List<String> list3 = this.getAllowedHeaders();
        n = n * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        List<String> list4 = this.getExposedHeaders();
        n = n * 59 + (list4 == null ? 43 : ((Object)list4).hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "CorsProperties(enabled=" + this.isEnabled() + ", allowedOrigins=" + this.getAllowedOrigins() + ", allowedMethods=" + this.getAllowedMethods() + ", allowedHeaders=" + this.getAllowedHeaders() + ", allowCredentials=" + this.isAllowCredentials() + ", maxAge=" + this.getMaxAge() + ", exposedHeaders=" + this.getExposedHeaders() + ")";
    }
}

