/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.config.properties;

import com.lenovo.cloud.framework.custom.security.constants.CustomSecurityConstants;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="lenovo.security.headers")
public class SecurityHeadersProperties {
    private boolean enabled = true;
    private List<String> excludeUrls = CustomSecurityConstants.EXCLUDE_URLS;
    private String xFrameOptions = "SAMEORIGIN";
    private String xXssProtection = "1; mode=block";
    private String xContentTypeOptions = "nosniff";
    private String strictTransportSecurity = "max-age=31536000; includeSubDomains";
    private String contentSecurityPolicy = "default-src 'self'; script-src 'self' 'unsafe-inline' 'unsafe-eval'; style-src 'self' 'unsafe-inline'; img-src 'self' data: https:; font-src 'self'; frame-ancestors 'none';";
    private String referrerPolicy = "strict-origin-when-cross-origin";
    private String permissionsPolicy = "geolocation=(), microphone=(), camera=(), payment=(), usb=()";

    @Generated
    public SecurityHeadersProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public List<String> getExcludeUrls() {
        return this.excludeUrls;
    }

    @Generated
    public String getXFrameOptions() {
        return this.xFrameOptions;
    }

    @Generated
    public String getXXssProtection() {
        return this.xXssProtection;
    }

    @Generated
    public String getXContentTypeOptions() {
        return this.xContentTypeOptions;
    }

    @Generated
    public String getStrictTransportSecurity() {
        return this.strictTransportSecurity;
    }

    @Generated
    public String getContentSecurityPolicy() {
        return this.contentSecurityPolicy;
    }

    @Generated
    public String getReferrerPolicy() {
        return this.referrerPolicy;
    }

    @Generated
    public String getPermissionsPolicy() {
        return this.permissionsPolicy;
    }

    @Generated
    public SecurityHeadersProperties setEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    @Generated
    public SecurityHeadersProperties setExcludeUrls(List<String> list) {
        this.excludeUrls = list;
        return this;
    }

    @Generated
    public SecurityHeadersProperties setXFrameOptions(String string) {
        this.xFrameOptions = string;
        return this;
    }

    @Generated
    public SecurityHeadersProperties setXXssProtection(String string) {
        this.xXssProtection = string;
        return this;
    }

    @Generated
    public SecurityHeadersProperties setXContentTypeOptions(String string) {
        this.xContentTypeOptions = string;
        return this;
    }

    @Generated
    public SecurityHeadersProperties setStrictTransportSecurity(String string) {
        this.strictTransportSecurity = string;
        return this;
    }

    @Generated
    public SecurityHeadersProperties setContentSecurityPolicy(String string) {
        this.contentSecurityPolicy = string;
        return this;
    }

    @Generated
    public SecurityHeadersProperties setReferrerPolicy(String string) {
        this.referrerPolicy = string;
        return this;
    }

    @Generated
    public SecurityHeadersProperties setPermissionsPolicy(String string) {
        this.permissionsPolicy = string;
        return this;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecurityHeadersProperties)) {
            return false;
        }
        SecurityHeadersProperties securityHeadersProperties = (SecurityHeadersProperties)object;
        if (!securityHeadersProperties.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != securityHeadersProperties.isEnabled()) {
            return false;
        }
        List<String> list = this.getExcludeUrls();
        List<String> list2 = securityHeadersProperties.getExcludeUrls();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        String string = this.getXFrameOptions();
        String string2 = securityHeadersProperties.getXFrameOptions();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getXXssProtection();
        String string4 = securityHeadersProperties.getXXssProtection();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getXContentTypeOptions();
        String string6 = securityHeadersProperties.getXContentTypeOptions();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getStrictTransportSecurity();
        String string8 = securityHeadersProperties.getStrictTransportSecurity();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getContentSecurityPolicy();
        String string10 = securityHeadersProperties.getContentSecurityPolicy();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        String string11 = this.getReferrerPolicy();
        String string12 = securityHeadersProperties.getReferrerPolicy();
        if (string11 == null ? string12 != null : !string11.equals(string12)) {
            return false;
        }
        String string13 = this.getPermissionsPolicy();
        String string14 = securityHeadersProperties.getPermissionsPolicy();
        return !(string13 == null ? string14 != null : !string13.equals(string14));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof SecurityHeadersProperties;
    }

    @Generated
    public int hashCode() {
        int n = 1;
        n = n * 59 + (this.isEnabled() ? 79 : 97);
        List<String> list = this.getExcludeUrls();
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        String string = this.getXFrameOptions();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getXXssProtection();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getXContentTypeOptions();
        n = n * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getStrictTransportSecurity();
        n = n * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getContentSecurityPolicy();
        n = n * 59 + (string5 == null ? 43 : string5.hashCode());
        String string6 = this.getReferrerPolicy();
        n = n * 59 + (string6 == null ? 43 : string6.hashCode());
        String string7 = this.getPermissionsPolicy();
        n = n * 59 + (string7 == null ? 43 : string7.hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "SecurityHeadersProperties(enabled=" + this.isEnabled() + ", excludeUrls=" + this.getExcludeUrls() + ", xFrameOptions=" + this.getXFrameOptions() + ", xXssProtection=" + this.getXXssProtection() + ", xContentTypeOptions=" + this.getXContentTypeOptions() + ", strictTransportSecurity=" + this.getStrictTransportSecurity() + ", contentSecurityPolicy=" + this.getContentSecurityPolicy() + ", referrerPolicy=" + this.getReferrerPolicy() + ", permissionsPolicy=" + this.getPermissionsPolicy() + ")";
    }
}

