/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.lenovo.cloud.framework.common.util.web.WebUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActuatorIpWhiteFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(ActuatorIpWhiteFilter.class);
    private String[] actuatorIpWhitelist;
    private String managementContextPath;

    public String[] getActuatorIpWhitelist() {
        return this.actuatorIpWhitelist;
    }

    public void setActuatorIpWhitelist(String[] stringArray) {
        this.actuatorIpWhitelist = stringArray;
    }

    public String getManagementContextPath() {
        return this.managementContextPath;
    }

    public void setManagementContextPath(String string) {
        this.managementContextPath = string;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String string = WebUtils.getIp((HttpServletRequest)httpServletRequest);
        String string2 = httpServletRequest.getRequestURI();
        if (!this.isMatchWhiteList(string) && string2.contains(this.managementContextPath)) {
            httpServletResponse.setContentType("application/json");
            httpServletResponse.setCharacterEncoding("UTF-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write("{\"code\":401}");
            printWriter.flush();
            printWriter.close();
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private boolean isMatchWhiteList(String string) {
        List<String> list = Arrays.asList(this.actuatorIpWhitelist);
        return list.stream().anyMatch(string2 -> string.startsWith((String)string2));
    }
}

