/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.lenovo.cloud.framework.custom.security.config.properties.ActuatorProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class ActuatorSecurityFilter
extends OncePerRequestFilter {
    private final ActuatorProperties properties;
    private final AntPathMatcher pathMatcher;

    public ActuatorSecurityFilter(AntPathMatcher antPathMatcher, ActuatorProperties actuatorProperties) {
        this.pathMatcher = antPathMatcher;
        this.properties = actuatorProperties;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String string = httpServletRequest.getRequestURI();
        if (!string.startsWith(this.properties.getBasePath())) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (this.isExcludedUrl(string)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String string2 = this.getClientIp(httpServletRequest);
        if (!this.isWhitelistedIp(string2)) {
            httpServletResponse.sendError(403, "Access denied");
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private boolean isExcludedUrl(String string) {
        List<String> list = this.properties.getExcludeUrls();
        return list.stream().anyMatch(string2 -> this.pathMatcher.match(string2, string));
    }

    private boolean isWhitelistedIp(String string) {
        List<String> list = this.properties.getIpWhitelist();
        return list.contains(string);
    }

    private String getClientIp(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("X-Forwarded-For");
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("HTTP_CLIENT_IP");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        return string;
    }
}

