/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.lenovo.cloud.framework.custom.security.config.properties.FileUploadProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class FileUploadSecurityFilter
extends OncePerRequestFilter {
    private final AntPathMatcher pathMatcher;
    private final FileUploadProperties properties;

    public FileUploadSecurityFilter(AntPathMatcher antPathMatcher, FileUploadProperties fileUploadProperties) {
        this.pathMatcher = antPathMatcher;
        this.properties = fileUploadProperties;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.isExcludedUrl(httpServletRequest.getRequestURI())) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (httpServletRequest instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)httpServletRequest;
            for (String string : multipartHttpServletRequest.getFileMap().keySet()) {
                MultipartFile multipartFile = multipartHttpServletRequest.getFile(string);
                if (multipartFile == null || multipartFile.isEmpty()) continue;
                if (multipartFile.getSize() > this.properties.getMaxSize()) {
                    httpServletResponse.sendError(400, "File size exceeds limit");
                    return;
                }
                String string2 = multipartFile.getContentType();
                if (string2 != null && !this.properties.getAllowedTypes().contains(string2)) {
                    httpServletResponse.sendError(400, "File type not allowed");
                    return;
                }
                String string3 = multipartFile.getOriginalFilename();
                if (string3 == null || this.isValidFileName(string3)) continue;
                httpServletResponse.sendError(400, "Invalid file name");
                return;
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private boolean isExcludedUrl(String string) {
        List<String> list = this.properties.getExcludeUrls();
        return list.stream().anyMatch(string2 -> this.pathMatcher.match(string2, string));
    }

    private boolean isValidFileName(String string) {
        if (string.contains("..") || string.contains("/") || string.contains("\\")) {
            return false;
        }
        return string.matches("^[a-zA-Z0-9._-]+$");
    }
}

