/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.lenovo.cloud.framework.custom.security.filter.InjectionAttackWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.util.StringUtils;

public class InjectionAttackFilter
implements Filter {
    private static final String X_FRAME_VALUE = "SAMEORIGIN";
    private static final String X_FRAME_HEADER = "X-FRAME-OPTIONS";
    public static final String FILTER_XSS_PARAM_NAME = "filter_xss";
    public static final String FILTER_SQL_INJECTION_PARAM_NAME = "filter_sql_injection";
    public static final String CLICK_JACKING_HEADER = "click_jacking_header";
    boolean filterXSS = true;
    boolean filterSQL = true;
    boolean clickJacking = true;

    public void setFilterXSS(boolean bl) {
        this.filterXSS = bl;
    }

    public void setFilterSQL(boolean bl) {
        this.filterSQL = bl;
    }

    public void setClickJacking(boolean bl) {
        this.clickJacking = bl;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        InjectionAttackWrapper injectionAttackWrapper = new InjectionAttackWrapper((HttpServletRequest)servletRequest, this.filterXSS, this.filterSQL);
        this.filterClickJack(servletResponse);
        filterChain.doFilter((ServletRequest)injectionAttackWrapper, servletResponse);
    }

    private void filterClickJack(ServletResponse servletResponse) {
        HttpServletResponse httpServletResponse;
        if (this.clickJacking && servletResponse instanceof HttpServletResponse && !(httpServletResponse = (HttpServletResponse)servletResponse).containsHeader(X_FRAME_HEADER)) {
            httpServletResponse.addHeader(X_FRAME_HEADER, X_FRAME_VALUE);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String string = filterConfig.getInitParameter(FILTER_XSS_PARAM_NAME);
        String string2 = filterConfig.getInitParameter(FILTER_SQL_INJECTION_PARAM_NAME);
        String string3 = filterConfig.getInitParameter(CLICK_JACKING_HEADER);
        if (StringUtils.hasText((String)string)) {
            this.filterXSS = Boolean.valueOf(string);
        }
        if (StringUtils.hasText((String)string2)) {
            this.filterSQL = Boolean.valueOf(string2);
        }
        if (StringUtils.hasText((String)string3)) {
            this.clickJacking = Boolean.valueOf(string3);
        }
    }
}

