/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InjectionAttackWrapper
extends HttpServletRequestWrapper {
    private static final String EVENTS = "((?i)onload|onunload|onchange|onsubmit|onreset|onselect|onblur|onfocus|onkeydown|onkeypress|onkeyup|onclick|ondblclick|onmousedown|onmousemove|onmouseout|onmouseover|onmouseup|onerror)";
    private static final String XSS_HTML_TAG = "(%3C)|(%3E)|[<>]+";
    private static final String XSS_INJECTION = "((%22%20)|(%22\\s)|('%22)|(%22\\+))\\w.*|(\\s|%20)((?i)onload|onunload|onchange|onsubmit|onreset|onselect|onblur|onfocus|onkeydown|onkeypress|onkeyup|onclick|ondblclick|onmousedown|onmousemove|onmouseout|onmouseover|onmouseup|onerror).*|(%3D)|(%7C)";
    private static final String XSS_REGEX = "(%3C)|(%3E)|[<>]+|((%22%20)|(%22\\s)|('%22)|(%22\\+))\\w.*|(\\s|%20)((?i)onload|onunload|onchange|onsubmit|onreset|onselect|onblur|onfocus|onkeydown|onkeypress|onkeyup|onclick|ondblclick|onmousedown|onmousemove|onmouseout|onmouseover|onmouseup|onerror).*|(%3D)|(%7C)";
    private static final String SQL_REGEX = "('.+--)|(--)|(\\|)|(%7C)";
    boolean filterXSS = true;
    boolean filterSQL = true;

    public InjectionAttackWrapper(HttpServletRequest httpServletRequest, boolean bl, boolean bl2) {
        super(httpServletRequest);
        this.filterXSS = bl;
        this.filterSQL = bl2;
    }

    public InjectionAttackWrapper(HttpServletRequest httpServletRequest) {
        this(httpServletRequest, true, true);
    }

    public String getParameter(String string) {
        String string2 = super.getParameter(string);
        return this.filterParamString(string2);
    }

    public Map<String, String[]> getParameterMap() {
        Map map = super.getParameterMap();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(map.size());
        Set set = map.keySet();
        for (String string : set) {
            String[] stringArray = (String[])map.get(string);
            String[] stringArray2 = this.filterStringArray(stringArray);
            hashMap.put(string, stringArray2);
        }
        return hashMap;
    }

    protected String[] filterStringArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.filterParamString(stringArray[i]);
        }
        return stringArray2;
    }

    public String[] getParameterValues(String string) {
        String[] stringArray = super.getParameterValues(string);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.filterParamString(stringArray[i]);
        }
        return stringArray2;
    }

    protected String filterParamString(String string) {
        if (string == null) {
            return null;
        }
        if (this.filterXSS()) {
            string = string.replaceAll(XSS_REGEX, "");
        }
        if (this.filterSQL()) {
            string = string.replaceAll(SQL_REGEX, "");
        }
        return string;
    }

    public Cookie[] getCookies() {
        Cookie[] cookieArray = super.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = cookieArray[i];
                cookie.setValue(this.filterParamString(cookie.getValue()));
            }
        }
        return cookieArray;
    }

    public String getQueryString() {
        return this.filterParamString(super.getQueryString());
    }

    protected boolean filterXSS() {
        return this.filterXSS;
    }

    protected boolean filterSQL() {
        return this.filterSQL;
    }
}

