/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.lenovo.cloud.framework.custom.security.config.properties.IpBlacklistProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class IpBlacklistFilter
extends OncePerRequestFilter {
    private final RedisTemplate<String, Object> redisTemplate;
    private final IpBlacklistProperties ipBlacklistProperties;

    public IpBlacklistFilter(RedisTemplate<String, Object> redisTemplate, IpBlacklistProperties ipBlacklistProperties) {
        this.redisTemplate = redisTemplate;
        this.ipBlacklistProperties = ipBlacklistProperties;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (!this.ipBlacklistProperties.isEnabled()) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String string = this.getClientIp(httpServletRequest);
        if (this.isIpWhitelisted(string)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (this.isIpBlacklisted(string)) {
            httpServletResponse.setStatus(HttpStatus.FORBIDDEN.value());
            httpServletResponse.getWriter().write("IP is blacklisted");
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private String getClientIp(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("X-Forwarded-For");
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("HTTP_CLIENT_IP");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        return string;
    }

    private boolean isIpWhitelisted(String string) {
        return this.ipBlacklistProperties.getIpWhitelist().contains(string);
    }

    private boolean isIpBlacklisted(String string) {
        if (this.ipBlacklistProperties.getStaticBlacklist().contains(string)) {
            return true;
        }
        String string2 = "ip_blacklist:" + string;
        return Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)string2));
    }
}

