/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.lenovo.cloud.framework.custom.security.config.properties.RateLimitProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class RateLimitFilter
extends OncePerRequestFilter {
    private final RedisTemplate<String, Object> redisTemplate;
    private final RateLimitProperties rateLimitProperties;

    public RateLimitFilter(RedisTemplate<String, Object> redisTemplate, RateLimitProperties rateLimitProperties) {
        this.redisTemplate = redisTemplate;
        this.rateLimitProperties = rateLimitProperties;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (!this.rateLimitProperties.isEnabled()) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String string = this.getClientIp(httpServletRequest);
        if (this.isIpWhitelisted(string)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String string2 = "rate_limit:" + string;
        Integer n = (Integer)this.redisTemplate.opsForValue().get((Object)string2);
        if (n == null) {
            this.redisTemplate.opsForValue().set((Object)string2, (Object)1, this.rateLimitProperties.getTimeWindow(), TimeUnit.SECONDS);
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (n >= this.rateLimitProperties.getMaxRequests()) {
            httpServletResponse.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            httpServletResponse.getWriter().write("Too many requests");
            return;
        }
        this.redisTemplate.opsForValue().increment((Object)string2);
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private String getClientIp(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("X-Forwarded-For");
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("HTTP_CLIENT_IP");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (string == null || string.isEmpty() || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        return string;
    }

    private boolean isIpWhitelisted(String string) {
        return this.rateLimitProperties.getIpWhitelist().contains(string);
    }
}

