/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.lenovo.cloud.framework.custom.security.config.properties.SqlInjectionProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class SqlInjectionFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(SqlInjectionFilter.class);
    private final AntPathMatcher pathMatcher;
    private final SqlInjectionProperties properties;
    private final List<Pattern> sqlPatterns;

    public SqlInjectionFilter(AntPathMatcher antPathMatcher, SqlInjectionProperties sqlInjectionProperties) {
        this.pathMatcher = antPathMatcher;
        this.properties = sqlInjectionProperties;
        this.sqlPatterns = this.initializeSqlPatterns();
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.isExcludedUrl(httpServletRequest.getRequestURI())) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (this.checkSqlInjection(httpServletRequest)) {
            String string = this.properties.isShowDetails() ? "SQL injection attack detected" : "Invalid request";
            httpServletResponse.sendError(403, string);
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private boolean isExcludedUrl(String string) {
        List<String> list = this.properties.getExcludeUrls();
        return list.stream().anyMatch(string2 -> this.pathMatcher.match(string2, string));
    }

    private boolean checkSqlInjection(HttpServletRequest httpServletRequest) {
        Map map = httpServletRequest.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            String[] stringArray;
            String string = (String)entry.getKey();
            for (String string2 : stringArray = (String[])entry.getValue()) {
                if (!this.checkSqlInjectionPattern(string2)) continue;
                this.logAttack(string, string2);
                return true;
            }
        }
        return false;
    }

    private boolean checkSqlInjectionPattern(String string) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        for (String object : this.properties.getCustomRules()) {
            if (!Pattern.compile(object, 2).matcher(string).find()) continue;
            return true;
        }
        for (String string2 : this.properties.getSqlKeywords()) {
            if (!string.toLowerCase().contains(string2.toLowerCase())) continue;
            return true;
        }
        for (Pattern pattern : this.sqlPatterns) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    private void logAttack(String string, String string2) {
        if (this.properties.isLogAttack()) {
            logger.warn("SQL injection attack detected - Parameter: {}, Value: {}", (Object)string, (Object)string2);
        }
    }

    private List<Pattern> initializeSqlPatterns() {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        arrayList.add(Pattern.compile("(?i)(select|insert|update|delete|drop|union|exec|declare|xp_cmdshell)"));
        arrayList.add(Pattern.compile("(?i)(--|;|'|\"|/\\*|\\*/)"));
        arrayList.add(Pattern.compile("(?i)(or\\s+1\\s*=\\s*1|or\\s+'1'\\s*=\\s*'1')"));
        if (this.properties.isStrictMode()) {
            arrayList.add(Pattern.compile("(?i)(waitfor|delay|shutdown|backup|restore)"));
            arrayList.add(Pattern.compile("(?i)(sysdatabases|sysobjects|syscolumns)"));
            arrayList.add(Pattern.compile("(?i)(@@version|@@servername|@@language)"));
        }
        return arrayList;
    }
}

