/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.lenovo.cloud.framework.custom.security.config.properties.XssProperties;
import com.lenovo.cloud.framework.custom.security.filter.XssHttpServletRequestWrapper;
import com.lenovo.cloud.framework.custom.security.filter.XssHttpServletResponseWrapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.HtmlUtils;

public class XssFilter
extends OncePerRequestFilter {
    private final AntPathMatcher pathMatcher;
    private final XssProperties properties;

    public XssFilter(AntPathMatcher antPathMatcher, XssProperties xssProperties) {
        this.pathMatcher = antPathMatcher;
        this.properties = xssProperties;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.isExcludedUrl(httpServletRequest.getRequestURI())) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        XssHttpServletRequestWrapper xssHttpServletRequestWrapper = new XssHttpServletRequestWrapper(httpServletRequest);
        XssHttpServletResponseWrapper xssHttpServletResponseWrapper = new XssHttpServletResponseWrapper(httpServletResponse);
        filterChain.doFilter((ServletRequest)xssHttpServletRequestWrapper, (ServletResponse)xssHttpServletResponseWrapper);
        String string = xssHttpServletResponseWrapper.getContentAsString();
        if (string != null && !string.isEmpty()) {
            string = HtmlUtils.htmlEscape((String)string);
            httpServletResponse.getWriter().write(string);
        }
    }

    private boolean isExcludedUrl(String string) {
        List<String> list = this.properties.getExcludeUrls();
        return list.stream().anyMatch(string2 -> this.pathMatcher.match(string2, string));
    }
}

