/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class XssHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private ServletOutputStream out = new WrapperServletOutputStream(this.buffer);
    private PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.buffer));

    public XssHttpServletResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public ServletOutputStream getOutputStream() {
        return this.out;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void reset() {
        this.buffer.reset();
    }

    public String getContentAsString() {
        try {
            this.flushBuffer();
            return this.buffer.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to get content as string", iOException);
        }
    }

    private static class WrapperServletOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream buffer;

        public WrapperServletOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            this.buffer = byteArrayOutputStream;
        }

        public void write(int n) {
            this.buffer.write(n);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

