/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=4)
public class XxeFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(XxeFilter.class);
    private static final List<String> XML_CONTENT_TYPES = Arrays.asList("application/xml", "text/xml", "application/xml-dtd", "application/xml-external-parsed-entity");
    private static final List<String> XXE_PATTERNS = Arrays.asList("<!DOCTYPE", "<!ENTITY", "SYSTEM", "PUBLIC", "file://", "http://", "https://", "ftp://", "jar:", "netdoc:", "gopher:", "data:", "php://", "zlib://", "data://", "glob://", "phar://", "ssh2://", "rar://", "ogg://", "expect://");

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String string = httpServletRequest.getContentType();
        if (string != null && this.isXmlContentType(string) && this.containsXxeInBody(httpServletRequest)) {
            logger.warn("XXE attack detected from IP: {}", (Object)httpServletRequest.getRemoteAddr());
            httpServletResponse.sendError(400, "XXE attack detected");
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean isXmlContentType(String string) {
        return XML_CONTENT_TYPES.stream().anyMatch(string2 -> string.toLowerCase().contains(string2.toLowerCase()));
    }

    private boolean containsXxeInBody(HttpServletRequest httpServletRequest) throws IOException {
        String string = httpServletRequest.getReader().lines().reduce("", String::concat).toLowerCase();
        return XXE_PATTERNS.stream().anyMatch(string2 -> string.contains(string2.toLowerCase()));
    }
}

