/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.dict.core;

import cn.hutool.core.util.ObjectUtil;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.lenovo.cloud.framework.common.core.KeyValue;
import com.lenovo.cloud.framework.common.util.cache.CacheUtils;
import com.lenovo.cloud.module.system.api.dict.DictDataApi;
import com.lenovo.cloud.module.system.api.dict.dto.DictDataRespDTO;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictFrameworkUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictFrameworkUtils.class);
    private static DictDataApi dictDataApi;
    private static final DictDataRespDTO DICT_DATA_NULL;
    private static final LoadingCache<KeyValue<String, String>, DictDataRespDTO> GET_DICT_DATA_CACHE;
    private static final LoadingCache<String, List<String>> GET_DICT_DATA_LIST_CACHE;
    private static final LoadingCache<KeyValue<String, String>, DictDataRespDTO> PARSE_DICT_DATA_CACHE;

    public static void init(DictDataApi dictDataApi) {
        DictFrameworkUtils.dictDataApi = dictDataApi;
        log.info("[init][\u521d\u59cb\u5316 DictFrameworkUtils \u6210\u529f]");
    }

    public static String getDictDataLabel(String string, Integer n) {
        return ((DictDataRespDTO)GET_DICT_DATA_CACHE.get((Object)new KeyValue((Object)string, (Object)String.valueOf(n)))).getLabel();
    }

    public static String getDictDataLabel(String string, String string2) {
        return ((DictDataRespDTO)GET_DICT_DATA_CACHE.get((Object)new KeyValue((Object)string, (Object)string2))).getLabel();
    }

    public static List<String> getDictDataLabelList(String string) {
        return (List)GET_DICT_DATA_LIST_CACHE.get((Object)string);
    }

    public static String parseDictDataValue(String string, String string2) {
        return ((DictDataRespDTO)PARSE_DICT_DATA_CACHE.get((Object)new KeyValue((Object)string, (Object)string2))).getValue();
    }

    static {
        DICT_DATA_NULL = new DictDataRespDTO();
        GET_DICT_DATA_CACHE = CacheUtils.buildAsyncReloadingCache((Duration)Duration.ofMinutes(1L), (CacheLoader)new CacheLoader<KeyValue<String, String>, DictDataRespDTO>(){

            public DictDataRespDTO load(KeyValue<String, String> keyValue) {
                return (DictDataRespDTO)ObjectUtil.defaultIfNull((Object)((DictDataRespDTO)dictDataApi.getDictData((String)keyValue.getKey(), (String)keyValue.getValue()).getCheckedData()), (Object)DICT_DATA_NULL);
            }
        });
        GET_DICT_DATA_LIST_CACHE = CacheUtils.buildAsyncReloadingCache((Duration)Duration.ofMinutes(1L), (CacheLoader)new CacheLoader<String, List<String>>(){

            public List<String> load(String string) {
                return dictDataApi.getDictDataLabelList(string);
            }
        });
        PARSE_DICT_DATA_CACHE = CacheUtils.buildAsyncReloadingCache((Duration)Duration.ofMinutes(1L), (CacheLoader)new CacheLoader<KeyValue<String, String>, DictDataRespDTO>(){

            public DictDataRespDTO load(KeyValue<String, String> keyValue) {
                return (DictDataRespDTO)ObjectUtil.defaultIfNull((Object)((DictDataRespDTO)dictDataApi.parseDictData((String)keyValue.getKey(), (String)keyValue.getValue()).getCheckedData()), (Object)DICT_DATA_NULL);
            }
        });
    }
}

