/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.sfzn.api.security;

import com.picc.gz.sfzn.api.vo.BaseRequest;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SignUtil {
    private static ThreadLocal<DateFormat> dateFormat = new ThreadLocal();

    public static String signRequest(BaseRequest request, String secret) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        TreeMap<String, String> signMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        signMap.put("header.appId", request.getHeader().getAppId());
        signMap.put("header.appKey", request.getHeader().getAppKey());
        signMap.put("header.timeStamp", sdf.format(request.getHeader().getTimeStamp()));
        if (request.getBody() != null) {
            PropertyDescriptor[] descriptorSrc;
            BeanInfo srcBeanInfo = Introspector.getBeanInfo(request.getBody().getClass());
            for (PropertyDescriptor property : descriptorSrc = srcBeanInfo.getPropertyDescriptors()) {
                SortedMap<String, String> childMap = SignUtil.getSignMap("body." + property.getName(), property.getReadMethod().invoke(request.getBody(), new Object[0]));
                signMap.putAll(childMap);
            }
        }
        StringBuilder signBuilder = new StringBuilder();
        for (Map.Entry m : signMap.entrySet()) {
            signBuilder.append("&").append((String)m.getKey()).append("=").append((String)m.getValue());
        }
        signBuilder.append("&secret=").append(secret);
        System.out.println("\u751f\u6210\u7684\u7b7e\u540d\u5b57\u7b26\u4e32\uff1a" + signBuilder.substring(1));
        return SignUtil.encodeSHA1(signBuilder.substring(1)).toUpperCase();
    }

    private static SortedMap<String, String> getSignMap(String basicName, Object object) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        TreeMap<String, String> signMap;
        block7: {
            block9: {
                block8: {
                    signMap = new TreeMap<String, String>();
                    if (object == null) break block7;
                    if (!(object instanceof Date)) break block8;
                    signMap.put(basicName, dateFormat.get().format(object));
                    break block7;
                }
                if (!SignUtil.isBaseType(object.getClass())) break block9;
                if (basicName.contains(".class")) break block7;
                signMap.put(basicName, object.toString());
                break block7;
            }
            if (object.getClass().isArray()) {
                int i = 0;
                for (Object o : (Object[])object) {
                    SortedMap<String, String> childMap = SignUtil.getSignMap(basicName + "[" + i + "]", o);
                    signMap.putAll(childMap);
                    ++i;
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                Iterator it = collection.iterator();
                int i = 0;
                while (it.hasNext()) {
                    SortedMap<String, String> childMap = SignUtil.getSignMap(basicName + "[" + i + "]", it.next());
                    signMap.putAll(childMap);
                    ++i;
                }
            } else {
                PropertyDescriptor[] descriptorSrc;
                BeanInfo srcBeanInfo = Introspector.getBeanInfo(object.getClass());
                for (PropertyDescriptor pd : descriptorSrc = srcBeanInfo.getPropertyDescriptors()) {
                    SortedMap<String, String> childMap = SignUtil.getSignMap(basicName + pd.getName(), pd.getReadMethod().invoke(object, new Object[0]));
                    signMap.putAll(childMap);
                }
            }
        }
        return signMap;
    }

    public static String encodeSHA1(String source) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(source.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isBaseType(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Date.class.isAssignableFrom(type)) {
            return true;
        }
        if (Boolean.class.equals(type)) {
            return true;
        }
        if (Character.class.equals(type)) {
            return true;
        }
        if (Class.class.equals(type)) {
            return true;
        }
        if (StringBuilder.class.equals(type)) {
            return true;
        }
        if (StringBuffer.class.equals(type)) {
            return true;
        }
        if (Object.class.equals(type)) {
            return true;
        }
        return Void.class.equals(type);
    }

    static {
        dateFormat.set(new SimpleDateFormat("yyyyMMddHHmmssSSS"));
    }
}

