/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.sfzn.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.sfzn.api.security.SignUtil;
import com.picc.gz.sfzn.api.vo.basic.BaseRequest;
import com.picc.gz.sfzn.api.vo.basic.BaseResponse;
import com.picc.gz.sfzn.api.vo.basic.RequestHeader;
import com.picc.gz.sfzn.api.vo.recommend.RecommendRequest;
import com.picc.gz.sfzn.api.vo.recommend.RecommendResp;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SfznRecommendApi {
    private String host;
    private String port;
    private String appSecret;
    private String appId;
    private String appKey;

    public SfznRecommendApi() {
    }

    public SfznRecommendApi(String host, String port, String appSecret, String appId, String appKey) {
        this.host = host;
        this.port = port;
        this.appSecret = appSecret;
        this.appId = appId;
        this.appKey = appKey;
    }

    public SfznRecommendApi(SfznRecommendApi other) {
        this.host = other.host;
        this.port = other.port;
        this.appSecret = other.appSecret;
        this.appId = other.appId;
        this.appKey = other.appKey;
    }

    public BaseResponse<RecommendResp> recommend(RecommendRequest body) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        builder.readTimeout(20L, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = builder.build();
        BaseRequest<RecommendRequest> request = new BaseRequest<RecommendRequest>();
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setAppId(this.appId);
        requestHeader.setAppKey(this.appKey);
        requestHeader.setTimeStamp(new Date());
        request.setHeader(requestHeader);
        request.setBody(body);
        String sign = SignUtil.signRequest(request, this.appSecret);
        requestHeader.setSign(sign);
        MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
        String requestJson = JSON.toJSONString(request);
        System.out.println("requestJson: " + requestJson);
        RequestBody requestBody = RequestBody.create((MediaType)JSON_TYPE, (String)requestJson);
        Cookie[] cookies = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getCookies();
        StringBuilder cookie = new StringBuilder();
        for (int i = 0; i < cookies.length; ++i) {
            if (i == cookies.length - 1) {
                cookie.append(cookies[i].getName());
                cookie.append("=");
                cookie.append(cookies[i].getValue());
                break;
            }
            cookie.append(cookies[i].getName());
            cookie.append("=");
            cookie.append(cookies[i].getValue());
            cookie.append(";");
        }
        Request httpRequest = new Request.Builder().url(String.format("http://%s:%s/sfzn/api/recommend", this.host, this.port)).post(requestBody).addHeader("cookie", cookie.toString()).build();
        try {
            Response response = okHttpClient.newCall(httpRequest).execute();
            String responseBody = response.body().string();
            if (responseBody == null || responseBody.trim().length() <= 0) {
                return BaseResponse.createError("1001", "\u670d\u52a1\u5668\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)responseBody);
            return BaseResponse.createSuc(jsonObject.getJSONObject("data").toJavaObject(RecommendResp.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.createError("1002", e.getLocalizedMessage());
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }
}

