/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.open.api.properties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="open.api")
public class OpenApiProperties
implements Serializable {
    public static final String OPEN_API_PREFIX = "open.api";
    private boolean enabled = true;
    String[] urls = new String[]{"/_api/*"};
    Map<String, String> initParameter = new HashMap<String, String>();

    public OpenApiProperties() {
        this.initParameter.put("confPath", "api/apiConfig.xml");
        this.initParameter.put("statusPath", "/_api/_status");
        this.initParameter.put("statusEnabled", "true");
        this.initParameter.put("logLevel", "INFO");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String[] getUrls() {
        return this.urls;
    }

    public Map<String, String> getInitParameter() {
        return this.initParameter;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUrls(String[] urls) {
        this.urls = urls;
    }

    public void setInitParameter(Map<String, String> initParameter) {
        this.initParameter = initParameter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiProperties)) {
            return false;
        }
        OpenApiProperties other = (OpenApiProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUrls(), other.getUrls())) {
            return false;
        }
        Map<String, String> this$initParameter = this.getInitParameter();
        Map<String, String> other$initParameter = other.getInitParameter();
        return !(this$initParameter == null ? other$initParameter != null : !((Object)this$initParameter).equals(other$initParameter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getUrls());
        Map<String, String> $initParameter = this.getInitParameter();
        result = result * 59 + ($initParameter == null ? 43 : ((Object)$initParameter).hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiProperties(enabled=" + this.isEnabled() + ", urls=" + Arrays.deepToString(this.getUrls()) + ", initParameter=" + this.getInitParameter() + ")";
    }
}

