/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.web.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.springframework.core.io.Resource;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.AbstractVersionStrategy;
import org.springframework.web.servlet.resource.VersionPathStrategy;

public class ContentParaVersionStrategy
extends AbstractVersionStrategy {
    public ContentParaVersionStrategy() {
        super((VersionPathStrategy)new FileNameVersionPathStrategy());
    }

    public String getResourceVersion(Resource resource) {
        try {
            byte[] content = FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
            return DigestUtils.md5DigestAsHex((byte[])content);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to calculate hash for resource [" + resource + "]", ex);
        }
    }

    protected static class FileNameVersionPathStrategy
    implements VersionPathStrategy {
        private static final Pattern pattern = Pattern.compile("-(\\S*)\\.");

        protected FileNameVersionPathStrategy() {
        }

        public String extractVersion(String requestPath) {
            return null;
        }

        public String removeVersion(String requestPath, String version) {
            return requestPath;
        }

        public String addVersion(String requestPath, String version) {
            String baseFilename = StringUtils.stripFilenameExtension((String)requestPath);
            String extension = StringUtils.getFilenameExtension((String)requestPath);
            return baseFilename + "." + extension + "?v_" + version;
        }
    }
}

