/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.global.common.request.page;

import com.sinosoftgz.global.common.request.AbstractBaseRequest;
import java.io.Serializable;
import javax.validation.constraints.NotNull;

public abstract class AbstractPageRequest<T>
extends AbstractBaseRequest<T>
implements Serializable {
    protected static final Integer DEFAULT_PAGE_NUM = 0;
    protected static final Integer DEFAULT_PAGE_SIZE = 10;
    private static final Integer MAX_LIMIT = 10000;
    @NotNull
    private Integer pageNum = 0;
    @NotNull
    private Integer pageSize = 10;

    public AbstractPageRequest(Integer pageNum, Integer pageSize) {
        if (pageNum < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        if (this.pageSize > MAX_LIMIT) {
            return MAX_LIMIT;
        }
        return this.pageSize;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPageRequest)) {
            return false;
        }
        AbstractPageRequest other = (AbstractPageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        return !(this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractPageRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AbstractPageRequest(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ")";
    }

    public AbstractPageRequest() {
    }
}

