/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.global.common.request.page;

import com.sinosoftgz.global.common.request.page.AbstractPageRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PageQueryRequest<T>
extends AbstractPageRequest<T>
implements Serializable {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    Map<String, String> orderByColumn = new LinkedHashMap<String, String>();

    public PageQueryRequest(@NotNull Integer pageNum, @NotNull Integer pageSize) {
        super(pageNum, pageSize);
    }

    public PageQueryRequest(@NotNull Integer pageNum, @NotNull Integer pageSize, Map<String, String> orderByColumn) {
        super(pageNum, pageSize);
        this.orderByColumn = orderByColumn;
    }

    public static PageQueryRequest of() {
        return new PageQueryRequest(DEFAULT_PAGE_NUM, DEFAULT_PAGE_SIZE);
    }

    public static PageQueryRequest of(@NotNull Integer pageNum) {
        return new PageQueryRequest(pageNum, DEFAULT_PAGE_SIZE);
    }

    public static PageQueryRequest of(@NotNull Integer pageNum, @NotNull Integer pageSize) {
        return new PageQueryRequest(pageNum, pageSize);
    }

    public static Pageable convertToPageable(PageQueryRequest pageQueryRequest) {
        Assert.notNull((Object)pageQueryRequest, (String)"Object must be have value!");
        Map<String, String> orderByColumn = pageQueryRequest.getOrderByColumn();
        PageRequest pageable = null;
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (!ObjectUtils.isEmpty(orderByColumn) && orders.size() > 0) {
            for (String key : orderByColumn.keySet()) {
                String value = orderByColumn.get(key);
                Sort.Order order = null;
                order = DESC.equals(value) ? new Sort.Order(Sort.Direction.DESC, key) : new Sort.Order(Sort.Direction.ASC, key);
                orders.add(order);
            }
        }
        if (!ObjectUtils.isEmpty(orders) && orders.size() > 0) {
            Sort sort = Sort.by(orders);
            pageable = PageRequest.of((int)pageQueryRequest.getPageNum(), (int)pageQueryRequest.getPageSize(), (Sort)sort);
        } else {
            pageable = PageRequest.of((int)pageQueryRequest.getPageNum(), (int)pageQueryRequest.getPageSize());
        }
        return pageable;
    }

    public Map<String, String> getOrderByColumn() {
        return this.orderByColumn;
    }

    public void setOrderByColumn(Map<String, String> orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public PageQueryRequest() {
    }
}

