/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.global.common.response;

import com.sinosoftgz.global.common.response.AbstractBaseResponse;
import com.sinosoftgz.global.common.response.enums.CommonResponseCodeEnum;
import java.io.Serializable;

public class BaseResponse<T>
extends AbstractBaseResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean success = true;
    private String message = CommonResponseCodeEnum.SUCCESS.getResultMsg();
    private String businessMessage;
    private String code = CommonResponseCodeEnum.SUCCESS.getResultCode();
    private T data;

    public static <T> BaseResponse<T> ok() {
        return BaseResponse.ok(null);
    }

    public static <T> BaseResponse<T> ok(T result) {
        BaseResponse<T> r = new BaseResponse<T>();
        r.setData(result);
        return r;
    }

    public static <T> BaseResponse<T> ok(String code, String message) {
        BaseResponse<T> r = new BaseResponse<T>();
        r.setCode(code);
        r.setMessage(message);
        return r;
    }

    public static <T> BaseResponse<T> ok(String code, String message, T result) {
        BaseResponse<T> r = BaseResponse.ok(code, message);
        r.setData(result);
        return r;
    }

    public static <T> BaseResponse<T> bad(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.BAD_REQUEST.getResultCode(), message);
    }

    public static <T> BaseResponse<T> unauthorized(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.UNAUTHORIZED.getResultCode(), message);
    }

    public static <T> BaseResponse<T> forbidden(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.FORBIDDEN.getResultCode(), message);
    }

    public static <T> BaseResponse<T> notFind(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.NOT_FOUND.getResultCode(), message);
    }

    public static <T> BaseResponse<T> error(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.SERVER_ERROR.getResultCode(), message);
    }

    public static <T> BaseResponse<T> error(T result) {
        BaseResponse<T> r = new BaseResponse<T>();
        r.setCode(CommonResponseCodeEnum.SERVER_ERROR.getResultCode());
        r.setMessage(CommonResponseCodeEnum.SERVER_ERROR.getResultMsg());
        r.setData(result);
        return r;
    }

    public static <T> BaseResponse<T> error() {
        return BaseResponse.error(CommonResponseCodeEnum.SERVER_ERROR.getResultCode(), CommonResponseCodeEnum.SERVER_ERROR.getResultMsg());
    }

    public static <T> BaseResponse<T> unavailable(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.SERVER_UNAVAILABLE.getResultCode(), message);
    }

    public static <T> BaseResponse<T> error(String code, String message) {
        BaseResponse<T> r = new BaseResponse<T>();
        r.setSuccess(Boolean.FALSE);
        r.setCode(code);
        r.setMessage(message);
        return r;
    }

    public static <T> BaseResponse<T> error(String code, String message, T result) {
        BaseResponse<T> r = BaseResponse.error(code, message);
        r.setData(result);
        return r;
    }

    public BaseResponse<T> code(String code) {
        this.code = code;
        return this;
    }

    public BaseResponse<T> message(String message) {
        this.message = message;
        return this;
    }

    public BaseResponse<T> result(T result) {
        this.data = result;
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public String getBusinessMessage() {
        return this.businessMessage;
    }

    public String getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setBusinessMessage(String businessMessage) {
        this.businessMessage = businessMessage;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$businessMessage = this.getBusinessMessage();
        String other$businessMessage = other.getBusinessMessage();
        if (this$businessMessage == null ? other$businessMessage != null : !this$businessMessage.equals(other$businessMessage)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $businessMessage = this.getBusinessMessage();
        result = result * 59 + ($businessMessage == null ? 43 : $businessMessage.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BaseResponse(success=" + this.isSuccess() + ", message=" + this.getMessage() + ", businessMessage=" + this.getBusinessMessage() + ", code=" + this.getCode() + ", data=" + this.getData() + ")";
    }
}

